-- COUNTER_TC_MACRO: Counter with terminal count implemented in a DSP48E
--                   Virtex-5
-- Xilinx HDL Libraries Guide, version 14.5

COUNTER_TC_MACRO_inst : COUNTER_TC_MACRO
generic map (
   COUNT_BY => X"000000000001", -- Count by value
   DEVICE => "VIRTEX5",         -- Target Device: "VIRTEX5", "VIRTEX6"
   DIRECTION => "UP",            -- Counter direction "UP" or "DOWN"
   RESET_UPON_TC => "FALSE",      -- Reset counter upon terminal count, "TRUE" or "FALSE"
   TC_VALUE => X"000000000000", -- Terminal count value
   WIDTH_DATA => 48)            -- Counter output bus width, 1-48
port map (
   Q => Q,        -- Counter output, width determined by WIDTH_DATA generic 
   TC => TC,      -- 1-bit terminal count output, high = terminal count is reached
   CLK => CLK,    -- 1-bit clock input
   CE => CE,      -- 1-bit clock enable input
   RST => RST       -- 1-bit active high synchronous reset
);
-- End of COUNTER_TC_MACRO_inst instantiation
