// RAMB16_S36: 512 x 32 + 4 Parity bits Single-Port RAM
//             Spartan-3
// Xilinx HDL Libraries Guide, version 14.5

RAMB16_S36 #(
   .INIT(36'h000000000),  // Value of output RAM registers at startup
   .SRVAL(36'h000000000), // Output value upon SSR assertion
   .WRITE_MODE("WRITE_FIRST"), // WRITE_FIRST, READ_FIRST or NO_CHANGE

   // The forllowing INIT_xx declarations specify the initial contents of the RAM
   // Address 0 to 127
   .INIT_00(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_01(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_02(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_03(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_04(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_05(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_06(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_07(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_08(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_09(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0A(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0B(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0C(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0D(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0E(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_0F(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   // Address 128 to 255
   .INIT_10(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_11(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_12(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_13(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_14(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_15(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_16(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_17(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_18(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_19(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1A(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1B(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1C(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1D(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1E(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_1F(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   // Address 256 to 383
   .INIT_20(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_21(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_22(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_23(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_24(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_25(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_26(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_27(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_28(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_29(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2A(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2B(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2C(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2D(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2E(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_2F(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   // Address 384 to 511
   .INIT_30(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_31(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_32(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_33(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_34(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_35(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_36(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_37(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_38(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_39(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3A(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3B(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3C(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3D(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3E(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),
   .INIT_3F(256'h00000000_00000000_00000000_00000000_00000000_00000000_00000000_00000000),

   // The next set of INITP_xx are for the parity bits
   // Address 0 to 127
   .INITP_00(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_01(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // Address 128 to 255
   .INITP_02(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_03(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // Address 256 to 383
   .INITP_04(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_05(256'h0000000000000000000000000000000000000000000000000000000000000000),
   // Address 384 to 511
   .INITP_06(256'h0000000000000000000000000000000000000000000000000000000000000000),
   .INITP_07(256'h0000000000000000000000000000000000000000000000000000000000000000)
) RAMB16_S36_inst (
   .DO(DO),      // 32-bit Data Output
   .DOP(DOP),    // 4-bit parity Output
   .ADDR(ADDR),  // 9-bit Address Input
   .CLK(CLK),    // Clock
   .DI(DI),      // 32-bit Data Input
   .DIP(DIP),    // 4-bit parity Input
   .EN(EN),      // RAM Enable Input
   .SSR(SSR),    // Synchronous Set/Reset Input
   .WE(WE)       // Write Enable Input
);

// End of RAMB16_S36_inst instantiation
