-- DPLL: Digital Phase-Locked Loop (DPLL)
--       Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

DPLL_inst : DPLL
generic map (
   CLKFBOUT_FRACT => 0,             -- 6-bit fraction M feedback divider (0-63)
   CLKFBOUT_MULT => 42,             -- Multiply value for all CLKOUT, (10-400)
   CLKIN_PERIOD => 0.0,             -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKOUT0_DIVIDE => 2,             -- Divide amount for CLKOUT0 (2-511)
   CLKOUT0_PHASE => 0.0,            -- Phase offset for CLKOUT0 (-360.000-360.000)
   CLKOUT0_PHASE_CTRL => "00",      -- CLKOUT0 fine phase shift or deskew select (0-11)
   CLKOUT1_DIVIDE => 2,             -- Divide amount for CLKOUT1 (2-511)
   CLKOUT1_PHASE => 0.0,            -- Phase offset for CLKOUT1 (-360.000-360.000)
   CLKOUT1_PHASE_CTRL => "00",      -- CLKOUT1 fine phase shift or deskew select (0-11)
   CLKOUT2_DIVIDE => 2,             -- Divide amount for CLKOUT2 (2-511)
   CLKOUT2_PHASE => 0.0,            -- Phase offset for CLKOUT2 (-360.000-360.000)
   CLKOUT2_PHASE_CTRL => "00",      -- CLKOUT2 fine phase shift or deskew select (0-11)
   CLKOUT3_DIVIDE => 2,             -- Divide amount for CLKOUT3 (2-511)
   CLKOUT3_PHASE => 0.0,            -- Phase offset for CLKOUT3 (-360.000-360.000)
   CLKOUT3_PHASE_CTRL => "00",      -- CLKOUT2 fine phase shift or deskew select (0-11)
   DESKEW_DELAY => 0,               -- Deskew optional programmable delay
   DESKEW_DELAY_EN => "FALSE",      -- Enable deskew optional programmable delay
   DESKEW_DELAY_PATH => "FALSE",    -- Select CLKFB_DESKEW (TRUE) or CLKIN_DESKEW (FALSE)
   DIVCLK_DIVIDE => 1,              -- Master division value
   IS_CLKFB_DESKEW_INVERTED => '0', -- Optional inversion for CLKFB_DESKEW
   IS_CLKIN_DESKEW_INVERTED => '0', -- Optional inversion for CLKIN_DESKEW
   IS_CLKIN_INVERTED => '0',        -- Optional inversion for CLKIN
   IS_PSEN_INVERTED => '0',         -- Optional inversion for PSEN
   IS_PSINCDEC_INVERTED => '0',     -- Optional inversion for PSINCDEC
   IS_PWRDWN_INVERTED => '0',       -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',          -- Optional inversion for RST
   LOCK_WAIT => "FALSE",            -- Lock wait
   PERF_MODE => "LIMITED",          -- Leave as default ("LIMITED"). For AMD IP use only.
   REF_JITTER => 0.0,               -- Reference input jitter in UI (0.000-0.200).
   ZHOLD => "FALSE"                 -- Negative hold time at the HDIO registers
)
port map (
   CLKOUT0 => CLKOUT0,             -- 1-bit output: General Clock output
   CLKOUT1 => CLKOUT1,             -- 1-bit output: General Clock output
   CLKOUT2 => CLKOUT2,             -- 1-bit output: General Clock output
   CLKOUT3 => CLKOUT3,             -- 1-bit output: General Clock output
   DO => DO,                       -- 16-bit output: DRP data output
   DRDY => DRDY,                   -- 1-bit output: DRP ready
   LOCKED => LOCKED,               -- 1-bit output: LOCK
   LOCKED_DESKEW => LOCKED_DESKEW, -- 1-bit output: LOCK DESKEW
   LOCKED_FB => LOCKED_FB,         -- 1-bit output: LOCK FEEDBACK
   PSDONE => PSDONE,               -- 1-bit output: Phase shift done
   CLKFB_DESKEW => CLKFB_DESKEW,   -- 1-bit input: Secondary clock input to PD
   CLKIN => CLKIN,                 -- 1-bit input: Input Clock
   CLKIN_DESKEW => CLKIN_DESKEW,   -- 1-bit input: Primary clock input to PD
   DADDR => DADDR,                 -- 7-bit input: DRP address
   DCLK => DCLK,                   -- 1-bit input: DRP clock
   DEN => DEN,                     -- 1-bit input: DRP enable
   DI => DI,                       -- 16-bit input: DRP data input
   DWE => DWE,                     -- 1-bit input: DRP write enable
   PSCLK => PSCLK,                 -- 1-bit input: Phase shift clock
   PSEN => PSEN,                   -- 1-bit input: Phase shift enable
   PSINCDEC => PSINCDEC,           -- 1-bit input: Phase shift increment/decrement
   PWRDWN => PWRDWN,               -- 1-bit input: Power-down
   RST => RST                      -- 1-bit input: Reset
);

-- End of DPLL_inst instantiation
