-- DSPCPLX: 18 x 18 + 58 complex multiply accumulate block
--          Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

DSPCPLX_inst : DSPCPLX
generic map (
   -- Feature Control Attributes: Data Path Selection
   A_INPUT_IM => "DIRECT",               -- Selects A_IM input source, "DIRECT" (A_IM port) or "CASCADE" (ACIN_IM port)
   A_INPUT_RE => "DIRECT",               -- Selects A_RE input source, "DIRECT" (A_RE port) or "CASCADE" (ACIN_RE port)
   B_INPUT_IM => "DIRECT",               -- Selects B_IM input source, "DIRECT" (B_IM port) or "CASCADE" (BCIN_IM port)
   B_INPUT_RE => "DIRECT",               -- Selects B_RE input source, "DIRECT" (B_RE port) or "CASCADE" (BCIN_RE port)
   RND_IM => X"000000000000000",         -- Rounding Constant
   RND_RE => X"000000000000000",         -- Rounding Constant
   LEGACY => "DSP58",
   -- Pattern Detector Attributes: Pattern Detection Configuration
   AUTORESET_PATDET_IM => "NO_RESET",    -- NO_RESET, RESET_MATCH, RESET_NOT_MATCH
   AUTORESET_PATDET_RE => "NO_RESET",    -- NO_RESET, RESET_MATCH, RESET_NOT_MATCH
   AUTORESET_PRIORITY_IM => "RESET",     -- Priority of AUTORESET_IM vs. CEP (CEP, RESET).
   AUTORESET_PRIORITY_RE => "RESET",     -- Priority of AUTORESET_RE vs. CEP (CEP, RESET).
   MASK_IM => X"0ffffffffffffff",        -- 58-bit mask value for pattern detect (1=ignore)
   MASK_RE => X"0ffffffffffffff",        -- 58-bit mask value for pattern detect (1=ignore)
   PATTERN_IM => X"000000000000000",     -- 58-bit pattern match for pattern detect
   PATTERN_RE => X"000000000000000",     -- 58-bit pattern match for pattern detect
   SEL_MASK_IM => "MASK",                -- C, MASK, ROUNDING_MODE1, ROUNDING_MODE2
   SEL_MASK_RE => "MASK",                -- C, MASK, ROUNDING_MODE1, ROUNDING_MODE2
   SEL_PATTERN_IM => "PATTERN",          -- Select pattern value (C, PATTERN)
   SEL_PATTERN_RE => "PATTERN",          -- Select pattern value (C, PATTERN)
   USE_PATTERN_DETECT_IM => "NO_PATDET", -- Enable pattern detect (NO_PATDET, PATDET)
   USE_PATTERN_DETECT_RE => "NO_PATDET", -- Enable pattern detect (NO_PATDET, PATDET)
   -- Programmable Inversion Attributes: Specifies built-in programmable inversion on specific pins
   IS_ALUMODE_IM_INVERTED => "0000",     -- Optional inversion for ALUMODE_IM
   IS_ALUMODE_RE_INVERTED => "0000",     -- Optional inversion for ALUMODE_RE
   IS_CARRYIN_IM_INVERTED => '0',        -- Optional inversion for CARRYIN_IM
   IS_CARRYIN_RE_INVERTED => '0',        -- Optional inversion for CARRYIN_RE
   IS_CLK_INVERTED => '0',               -- Optional inversion for CLK
   IS_CONJUGATE_A_INVERTED => '0',       -- Optional inversion for CONJUGATE_A
   IS_CONJUGATE_B_INVERTED => '0',       -- Optional inversion for CONJUGATE_B
   IS_OPMODE_IM_INVERTED => "000000000", -- Optional inversion for OPMODE_IM
   IS_OPMODE_RE_INVERTED => "000000000", -- Optional inversion for OPMODE_RE
   IS_RSTAD_INVERTED => '0',             -- Optional inversion for RSTAD
   IS_RSTALLCARRYIN_IM_INVERTED => '0',  -- Optional inversion for RSTALLCARRYIN_IM
   IS_RSTALLCARRYIN_RE_INVERTED => '0',  -- Optional inversion for RSTALLCARRYIN_RE
   IS_RSTALUMODE_IM_INVERTED => '0',     -- Optional inversion for RSTALUMODE_IM
   IS_RSTALUMODE_RE_INVERTED => '0',     -- Optional inversion for RSTALUMODE_RE
   IS_RSTA_IM_INVERTED => '0',           -- Optional inversion for RSTA_IM
   IS_RSTA_RE_INVERTED => '0',           -- Optional inversion for RSTA_RE
   IS_RSTB_IM_INVERTED => '0',           -- Optional inversion for RSTB_IM
   IS_RSTB_RE_INVERTED => '0',           -- Optional inversion for RSTB_RE
   IS_RSTCONJUGATE_A_INVERTED => '0',    -- Optional inversion for RSTCONJUGATE_A
   IS_RSTCONJUGATE_B_INVERTED => '0',    -- Optional inversion for RSTCONJUGATE_B
   IS_RSTCTRL_IM_INVERTED => '0',        -- Optional inversion for RSTCTRL_IM
   IS_RSTCTRL_RE_INVERTED => '0',        -- Optional inversion for RSTCTRL_RE
   IS_RSTC_IM_INVERTED => '0',           -- Optional inversion for RSTC_IM
   IS_RSTC_RE_INVERTED => '0',           -- Optional inversion for RSTC_RE
   IS_RSTM_IM_INVERTED => '0',           -- Optional inversion for RSTM_IM
   IS_RSTM_RE_INVERTED => '0',           -- Optional inversion for RSTM_RE
   IS_RSTP_IM_INVERTED => '0',           -- Optional inversion for RSTP_IM
   IS_RSTP_RE_INVERTED => '0',           -- Optional inversion for RSTP_RE
   -- Register Control Attributes: Pipeline Register Configuration
   ACASCREG_IM => 1,                     -- Number of pipeline stages between A_IM/ACIN_IM and ACOUT_IM (0-2)
   ACASCREG_RE => 1,                     -- Number of pipeline stages between A_RE/ACIN_RE and ACOUT_RE (0-2)
   ADREG => 1,                           -- Pipeline stages for pre-adder (0-1)
   ALUMODEREG_IM => 1,                   -- Pipeline stages for ALUMODE_IM (0-1)
   ALUMODEREG_RE => 1,                   -- Pipeline stages for ALUMODE_RE (0-1)
   AREG_IM => 2,                         -- Pipeline stages for A_IM (0-2)
   AREG_RE => 2,                         -- Pipeline stages for A_RE (0-2)
   BCASCREG_IM => 1,                     -- Number of pipeline stages between B_IM/BCIN_IM and BCOUT_IM (0-2)
   BCASCREG_RE => 1,                     -- Number of pipeline stages between B_RE/BCIN_RE and BCOUT_RE (0-2)
   BREG_IM => 2,                         -- Pipeline stages for B_IM (0-2)
   BREG_RE => 2,                         -- Pipeline stages for B_RE (0-2)
   CARRYINREG_IM => 1,                   -- Pipeline stages for CARRYIN_IM (0-1)
   CARRYINREG_RE => 1,                   -- Pipeline stages for CARRYIN_RE (0-1)
   CARRYINSELREG_IM => 1,                -- Pipeline stages for CARRYINSEL_IM (0-1)
   CARRYINSELREG_RE => 1,                -- Pipeline stages for CARRYINSEL_RE (0-1)
   CONJUGATEREG_A => 1,                  -- Pipeline stages for CONJUGATE_A (0-1)
   CONJUGATEREG_B => 1,                  -- Pipeline stages for CONJUGATE_B (0-1)
   CREG_IM => 1,                         -- Pipeline stages for C_IM (0-1)
   CREG_RE => 1,                         -- Pipeline stages for C_RE (0-1)
   MREG_IM => 1,                         -- Multiplier pipeline stages (0-1)
   MREG_RE => 1,                         -- Multiplier pipeline stages (0-1)
   OPMODEREG_IM => 1,                    -- Pipeline stages for OPMODE_IM (0-1)
   OPMODEREG_RE => 1,                    -- Pipeline stages for OPMODE_RE (0-1)
   PREG_IM => 1,                         -- Number of pipeline stages for P_IM (0-1)
   PREG_RE => 1,                         -- Number of pipeline stages for P_RE (0-1)
   RESET_MODE => "SYNC"                  -- Selection of synchronous or asynchronous reset. (ASYNC, SYNC).
)
port map (
   -- Cascade outputs: Cascade Ports
   ACOUT_IM => ACOUT_IM,                   -- 18-bit output: A_IM port cascade
   ACOUT_RE => ACOUT_RE,                   -- 18-bit output: A_RE port cascade
   BCOUT_IM => BCOUT_IM,                   -- 18-bit output: B_IM cascade
   BCOUT_RE => BCOUT_RE,                   -- 18-bit output: B_RE cascade
   CARRYCASCOUT_IM => CARRYCASCOUT_IM,     -- 1-bit output: Cascade carry
   CARRYCASCOUT_RE => CARRYCASCOUT_RE,     -- 1-bit output: Cascade carry
   MULTSIGNOUT_IM => MULTSIGNOUT_IM,       -- 1-bit output: Multiplier sign cascade
   MULTSIGNOUT_RE => MULTSIGNOUT_RE,       -- 1-bit output: Multiplier sign cascade
   PCOUT_IM => PCOUT_IM,                   -- 58-bit output: Cascade output
   PCOUT_RE => PCOUT_RE,                   -- 58-bit output: Cascade output
   -- Control outputs: Control Inputs/Status Bits
   OVERFLOW_IM => OVERFLOW_IM,             -- 1-bit output: Overflow in imaginary add/acc
   OVERFLOW_RE => OVERFLOW_RE,             -- 1-bit output: Overflow in real add/acc
   PATTERNBDETECT_IM => PATTERNBDETECT_IM, -- 1-bit output: Pattern bar detect
   PATTERNBDETECT_RE => PATTERNBDETECT_RE, -- 1-bit output: Pattern bar detect
   PATTERNDETECT_IM => PATTERNDETECT_IM,   -- 1-bit output: Pattern detect
   PATTERNDETECT_RE => PATTERNDETECT_RE,   -- 1-bit output: Pattern detect
   UNDERFLOW_IM => UNDERFLOW_IM,           -- 1-bit output: Underflow in add/acc
   UNDERFLOW_RE => UNDERFLOW_RE,           -- 1-bit output: Underflow in add/acc
   -- Data outputs: Data Ports
   CARRYOUT_IM => CARRYOUT_IM,             -- 1-bit output: Carry-out
   CARRYOUT_RE => CARRYOUT_RE,             -- 1-bit output: Carry-out
   P_IM => P_IM,                           -- 58-bit output: Primary data
   P_RE => P_RE,                           -- 58-bit output: Primary data
   -- Cascade inputs: Cascade Ports
   ACIN_IM => ACIN_IM,                     -- 18-bit input: A_IM cascade data
   ACIN_RE => ACIN_RE,                     -- 18-bit input: A_RE cascade data
   BCIN_IM => BCIN_IM,                     -- 18-bit input: B_IM cascade
   BCIN_RE => BCIN_RE,                     -- 18-bit input: B_RE cascade
   CARRYCASCIN_IM => CARRYCASCIN_IM,       -- 1-bit input: Cascade carry
   CARRYCASCIN_RE => CARRYCASCIN_RE,       -- 1-bit input: Cascade carry
   MULTSIGNIN_IM => MULTSIGNIN_IM,         -- 1-bit input: Multiplier sign cascade
   MULTSIGNIN_RE => MULTSIGNIN_RE,         -- 1-bit input: Multiplier sign cascade
   PCIN_IM => PCIN_IM,                     -- 58-bit input: P_IM cascade
   PCIN_RE => PCIN_RE,                     -- 58-bit input: P_IM cascade
   -- Control inputs: Control Inputs/Status Bits
   ALUMODE_IM => ALUMODE_IM,               -- 4-bit input: ALU_IM control
   ALUMODE_RE => ALUMODE_RE,               -- 4-bit input: ALU_RE control
   CARRYINSEL_IM => CARRYINSEL_IM,         -- 3-bit input: Carry select
   CARRYINSEL_RE => CARRYINSEL_RE,         -- 3-bit input: Carry select
   CLK => CLK,                             -- 1-bit input: Clock
   CONJUGATE_A => CONJUGATE_A,             -- 1-bit input: Select signal for cconjugate of A.
   CONJUGATE_B => CONJUGATE_B,             -- 1-bit input: Select signal for conjugate of B.
   OPMODE_IM => OPMODE_IM,                 -- 9-bit input: Operation mode
   OPMODE_RE => OPMODE_RE,                 -- 9-bit input: Operation mode
   -- Data inputs: Data Ports
   A_IM => A_IM,                           -- 18-bit input: A_IM data
   A_RE => A_RE,                           -- 18-bit input: A_RE data
   B_IM => B_IM,                           -- 18-bit input: B_IM data
   B_RE => B_RE,                           -- 18-bit input: B_RE data
   CARRYIN_IM => CARRYIN_IM,               -- 1-bit input: Carry-in
   CARRYIN_RE => CARRYIN_RE,               -- 1-bit input: Carry-in
   C_IM => C_IM,                           -- 58-bit input: C_IM data
   C_RE => C_RE,                           -- 58-bit input: C_RE data
   -- Reset/Clock Enable inputs: Reset/Clock Enable Inputs
   ASYNC_RST => ASYNC_RST,                 -- 1-bit input: Asynchronous reset for all registers.
   CEA1_IM => CEA1_IM,                     -- 1-bit input: Clock enable for 1st stage AREG_IM
   CEA1_RE => CEA1_RE,                     -- 1-bit input: Clock enable for 1st stage AREG_RE
   CEA2_IM => CEA2_IM,                     -- 1-bit input: Clock enable for 2nd stage AREG_IM
   CEA2_RE => CEA2_RE,                     -- 1-bit input: Clock enable for 2nd stage AREG_RE
   CEAD => CEAD,                           -- 1-bit input: Clock enable for ADREG
   CEALUMODE_IM => CEALUMODE_IM,           -- 1-bit input: Clock enable for ALUMODE_IM
   CEALUMODE_RE => CEALUMODE_RE,           -- 1-bit input: Clock enable for ALUMODE_RE
   CEB1_IM => CEB1_IM,                     -- 1-bit input: Clock enable for 1st stage BREG_IM
   CEB1_RE => CEB1_RE,                     -- 1-bit input: Clock enable for 1st stage BREG_RE
   CEB2_IM => CEB2_IM,                     -- 1-bit input: Clock enable for 2nd stage BREG_IM
   CEB2_RE => CEB2_RE,                     -- 1-bit input: Clock enable for 2nd stage BREG_RE
   CECARRYIN_IM => CECARRYIN_IM,           -- 1-bit input: Clock enable for CARRYINREG_IM
   CECARRYIN_RE => CECARRYIN_RE,           -- 1-bit input: Clock enable for CARRYINREG_RE
   CECONJUGATE_A => CECONJUGATE_A,         -- 1-bit input: Clock enable for CONJUGATE_A
   CECONJUGATE_B => CECONJUGATE_B,         -- 1-bit input: Clock enable for CONJUGATE_B
   CECTRL_IM => CECTRL_IM,                 -- 1-bit input: Clock enable for OPMODEREG_IM and CARRYINSELREG_IM
   CECTRL_RE => CECTRL_RE,                 -- 1-bit input: Clock enable for OPMODEREG_RE and CARRYINSELREG_RE
   CEC_IM => CEC_IM,                       -- 1-bit input: Clock enable for CREG_IM
   CEC_RE => CEC_RE,                       -- 1-bit input: Clock enable for CREG_RE
   CEM_IM => CEM_IM,                       -- 1-bit input: Clock enable for MREG_IM
   CEM_RE => CEM_RE,                       -- 1-bit input: Clock enable for MREG_RE
   CEP_IM => CEP_IM,                       -- 1-bit input: Clock enable for PREG_IM
   CEP_RE => CEP_RE,                       -- 1-bit input: Clock enable for PREG
   RSTAD => RSTAD,                         -- 1-bit input: Reset for ADREG
   RSTALLCARRYIN_IM => RSTALLCARRYIN_IM,   -- 1-bit input: Reset for CARRYINREG_IM
   RSTALLCARRYIN_RE => RSTALLCARRYIN_RE,   -- 1-bit input: Reset for CARRYINREG_RE
   RSTALUMODE_IM => RSTALUMODE_IM,         -- 1-bit input: Reset for ALUMODEREG_IM
   RSTALUMODE_RE => RSTALUMODE_RE,         -- 1-bit input: Reset for ALUMODEREG_RE
   RSTA_IM => RSTA_IM,                     -- 1-bit input: Reset for AREG_IM
   RSTA_RE => RSTA_RE,                     -- 1-bit input: Reset for AREG_RE
   RSTB_IM => RSTB_IM,                     -- 1-bit input: Reset for BREG_IM
   RSTB_RE => RSTB_RE,                     -- 1-bit input: Reset for BREG_RE
   RSTCONJUGATE_A => RSTCONJUGATE_A,       -- 1-bit input: Reset for CONJUGATE_A
   RSTCONJUGATE_B => RSTCONJUGATE_B,       -- 1-bit input: Reset for CONJUGATE_B
   RSTCTRL_IM => RSTCTRL_IM,               -- 1-bit input: Reset for OPMODEREG_IM and CARRYINSELREG_IM
   RSTCTRL_RE => RSTCTRL_RE,               -- 1-bit input: Reset for OPMODEREG_RE and CARRYINSELREG_RE
   RSTC_IM => RSTC_IM,                     -- 1-bit input: Reset for CREG_IM
   RSTC_RE => RSTC_RE,                     -- 1-bit input: Reset for CREG_RE
   RSTM_IM => RSTM_IM,                     -- 1-bit input: Reset for MREG_IM
   RSTM_RE => RSTM_RE,                     -- 1-bit input: Reset for MREG_RE
   RSTP_IM => RSTP_IM,                     -- 1-bit input: Reset for PREG_IM
   RSTP_RE => RSTP_RE                      -- 1-bit input: Reset for PREG_RE
);

-- End of DSPCPLX_inst instantiation
