-- MBUFGCTRL: Multi-Output Global Clock Control Buffer
--            Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

MBUFGCTRL_inst : MBUFGCTRL
generic map (
   CE_TYPE_CE0 => "SYNC",      -- HARDSYNC, SYNC
   CE_TYPE_CE1 => "SYNC",      -- HARDSYNC, SYNC
   INIT_OUT => 0,              -- Initial value of MBUFGCTRL output, (0-1)
   IS_CE0_INVERTED => '0',     -- Programmable inversion on CE0
   IS_CE1_INVERTED => '0',     -- Programmable inversion on CE1
   IS_I0_INVERTED => '0',      -- Programmable inversion on I0
   IS_I1_INVERTED => '0',      -- Programmable inversion on I1
   IS_IGNORE0_INVERTED => '0', -- Programmable inversion on IGNORE0
   IS_IGNORE1_INVERTED => '0', -- Programmable inversion on IGNORE1
   IS_S0_INVERTED => '0',      -- Programmable inversion on S0
   IS_S1_INVERTED => '0',      -- Programmable inversion on S1
   MODE => "PERFORMANCE",      -- PERFORMANCE, POWER
   PRESELECT_I0 => "FALSE",    -- MBUFGCTRL output uses I0 input, (FALSE, TRUE)
   PRESELECT_I1 => "FALSE"     -- MBUFGCTRL output uses I1 input, (FALSE, TRUE)
)
port map (
   O1 => O1,               -- 1-bit output: Buffer
   O2 => O2,               -- 1-bit output:  I/2 in PERFORMANCE MODE I in POWER MODE
   O3 => O3,               -- 1-bit output:  I/4 in PERFORMANCE MODE I/2 in POWER MODE
   O4 => O4,               -- 1-bit output:  I/8 in PERFORMANCE MODE I/4 in POWER MODE
   CE0 => CE0,             -- 1-bit input: Clock enable input for I0
   CE1 => CE1,             -- 1-bit input: Clock enable input for I1
   CLRB_LEAF => CLRB_LEAF, -- 1-bit input: Active low clear
   I0 => I0,               -- 1-bit input: Primary clock
   I1 => I1,               -- 1-bit input: Secondary clock
   IGNORE0 => IGNORE0,     -- 1-bit input: Clock ignore input for I0
   IGNORE1 => IGNORE1,     -- 1-bit input: Clock ignore input for I1
   S0 => S0,               -- 1-bit input: Clock select for I0
   S1 => S1                -- 1-bit input: Clock select for I1
);

-- End of MBUFGCTRL_inst instantiation
