-- MMCME3_ADV: Advanced Mixed Mode Clock Manager (MMCM)
--             Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

MMCME3_ADV_inst : MMCME3_ADV
generic map (
   BANDWIDTH => "OPTIMIZED",        -- Jitter programming (HIGH, LOW, OPTIMIZED)
   CLKFBOUT_MULT_F => 5.0,          -- Multiply value for all CLKOUT (2.000-64.000)
   CLKFBOUT_PHASE => 0.0,           -- Phase offset in degrees of CLKFB (-360.000-360.000)
   -- CLKIN_PERIOD: Input clock period in ns units, ps resolution (i.e., 33.333 is 30 MHz).
   CLKIN1_PERIOD => 0.0,
   CLKIN2_PERIOD => 0.0,
   CLKOUT0_DIVIDE_F => 1.0,         -- Divide amount for CLKOUT0 (1.000-128.000)
   -- CLKOUT0_DUTY_CYCLE - CLKOUT6_DUTY_CYCLE: Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT0_DUTY_CYCLE => 0.5,
   CLKOUT1_DUTY_CYCLE => 0.5,
   CLKOUT2_DUTY_CYCLE => 0.5,
   CLKOUT3_DUTY_CYCLE => 0.5,
   CLKOUT4_DUTY_CYCLE => 0.5,
   CLKOUT5_DUTY_CYCLE => 0.5,
   CLKOUT6_DUTY_CYCLE => 0.5,
   -- CLKOUT0_PHASE - CLKOUT6_PHASE: Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT0_PHASE => 0.0,
   CLKOUT1_PHASE => 0.0,
   CLKOUT2_PHASE => 0.0,
   CLKOUT3_PHASE => 0.0,
   CLKOUT4_PHASE => 0.0,
   CLKOUT5_PHASE => 0.0,
   CLKOUT6_PHASE => 0.0,
   -- CLKOUT1_DIVIDE - CLKOUT6_DIVIDE: Divide amount for CLKOUT (1-128)
   CLKOUT1_DIVIDE => 1,
   CLKOUT2_DIVIDE => 1,
   CLKOUT3_DIVIDE => 1,
   CLKOUT4_CASCADE => "FALSE",
   CLKOUT4_DIVIDE => 1,
   CLKOUT5_DIVIDE => 1,
   CLKOUT6_DIVIDE => 1,
   COMPENSATION => "AUTO",          -- AUTO, BUF_IN, EXTERNAL, INTERNAL, ZHOLD
   DIVCLK_DIVIDE => 1,              -- Master division value (1-106)
   -- Programmable Inversion Attributes: Specifies built-in programmable inversion on specific pins
   IS_CLKFBIN_INVERTED => '0',      -- Optional inversion for CLKFBIN
   IS_CLKIN1_INVERTED => '0',       -- Optional inversion for CLKIN1
   IS_CLKIN2_INVERTED => '0',       -- Optional inversion for CLKIN2
   IS_CLKINSEL_INVERTED => '0',     -- Optional inversion for CLKINSEL
   IS_PSEN_INVERTED => '0',         -- Optional inversion for PSEN
   IS_PSINCDEC_INVERTED => '0',     -- Optional inversion for PSINCDEC
   IS_PWRDWN_INVERTED => '0',       -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',          -- Optional inversion for RST
   -- REF_JITTER: Reference input jitter in UI (0.000-0.999).
   REF_JITTER1 => 0.0,
   REF_JITTER2 => 0.0,
   STARTUP_WAIT => "FALSE",         -- Delays DONE until MMCM is locked (FALSE, TRUE)
   -- Spread Spectrum: Spread Spectrum Attributes.
   SS_EN => "FALSE",                -- Enables spread spectrum (FALSE, TRUE)
   SS_MODE => "CENTER_HIGH",        -- CENTER_HIGH, CENTER_LOW, DOWN_HIGH, DOWN_LOW
   SS_MOD_PERIOD => 10000,          -- Spread spectrum modulation period (ns) (4000-40000)
   -- USE_FINE_PS: Fine phase shift enable (TRUE/FALSE)
   CLKFBOUT_USE_FINE_PS => "FALSE",
   CLKOUT0_USE_FINE_PS => "FALSE",
   CLKOUT1_USE_FINE_PS => "FALSE",
   CLKOUT2_USE_FINE_PS => "FALSE",
   CLKOUT3_USE_FINE_PS => "FALSE",
   CLKOUT4_USE_FINE_PS => "FALSE",
   CLKOUT5_USE_FINE_PS => "FALSE",
   CLKOUT6_USE_FINE_PS => "FALSE"
)
port map (
   -- Clock Outputs outputs: User configurable clock outputs
   CLKOUT0 => CLKOUT0,           -- 1-bit output: CLKOUT0
   CLKOUT0B => CLKOUT0B,         -- 1-bit output: Inverted CLKOUT0.
   CLKOUT1 => CLKOUT1,           -- 1-bit output: Primary clock
   CLKOUT1B => CLKOUT1B,         -- 1-bit output: Inverted CLKOUT1
   CLKOUT2 => CLKOUT2,           -- 1-bit output: CLKOUT2
   CLKOUT2B => CLKOUT2B,         -- 1-bit output: Inverted CLKOUT2
   CLKOUT3 => CLKOUT3,           -- 1-bit output: CLKOUT3
   CLKOUT3B => CLKOUT3B,         -- 1-bit output: Inverted CLKOUT3
   CLKOUT4 => CLKOUT4,           -- 1-bit output: CLKOUT4
   CLKOUT5 => CLKOUT5,           -- 1-bit output: CLKOUT5
   CLKOUT6 => CLKOUT6,           -- 1-bit output: CLKOUT6
   -- DRP Ports outputs: Dynamic reconfiguration ports
   DO => DO,                     -- 16-bit output: DRP data
   DRDY => DRDY,                 -- 1-bit output: DRP ready
   -- Dynamic Phase Shift Ports outputs: Ports used for dynamic phase shifting of the outputs
   PSDONE => PSDONE,             -- 1-bit output: Phase shift done
   -- Feedback outputs: Clock feedback ports
   CLKFBOUT => CLKFBOUT,         -- 1-bit output: Feedback clock
   CLKFBOUTB => CLKFBOUTB,       -- 1-bit output: Inverted CLKFBOUT
   -- Status Ports outputs: MMCM status ports
   CDDCDONE => CDDCDONE,         -- 1-bit output: Clock dynamic divide done
   CLKFBSTOPPED => CLKFBSTOPPED, -- 1-bit output: Feedback clock stopped
   CLKINSTOPPED => CLKINSTOPPED, -- 1-bit output: Input clock stopped
   LOCKED => LOCKED,             -- 1-bit output: LOCK
   CDDCREQ => CDDCREQ,           -- 1-bit input: Request to dynamic divide clock
   -- Clock Inputs inputs: Clock inputs
   CLKIN1 => CLKIN1,             -- 1-bit input: Primary clock
   CLKIN2 => CLKIN2,             -- 1-bit input: Secondary clock
   -- Control Ports inputs: MMCM control ports
   CLKINSEL => CLKINSEL,         -- 1-bit input: Clock select, High=CLKIN1 Low=CLKIN2
   PWRDWN => PWRDWN,             -- 1-bit input: Power-down
   RST => RST,                   -- 1-bit input: Reset
   -- DRP Ports inputs: Dynamic reconfiguration ports
   DADDR => DADDR,               -- 7-bit input: DRP address
   DCLK => DCLK,                 -- 1-bit input: DRP clock
   DEN => DEN,                   -- 1-bit input: DRP enable
   DI => DI,                     -- 16-bit input: DRP data
   DWE => DWE,                   -- 1-bit input: DRP write enable
   -- Dynamic Phase Shift Ports inputs: Ports used for dynamic phase shifting of the outputs
   PSCLK => PSCLK,               -- 1-bit input: Phase shift clock
   PSEN => PSEN,                 -- 1-bit input: Phase shift enable
   PSINCDEC => PSINCDEC,         -- 1-bit input: Phase shift increment/decrement
   -- Feedback inputs: Clock feedback ports
   CLKFBIN => CLKFBIN            -- 1-bit input: Feedback clock
);

-- End of MMCME3_ADV_inst instantiation
