-- MMCME4_ADV: Advanced Mixed Mode Clock Manager (MMCM)
--             Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

MMCME4_ADV_inst : MMCME4_ADV
generic map (
   BANDWIDTH => "OPTIMIZED",        -- Jitter programming
   CLKFBOUT_MULT_F => 5.0,          -- Multiply value for all CLKOUT
   CLKFBOUT_PHASE => 0.0,           -- Phase offset in degrees of CLKFB
   CLKFBOUT_USE_FINE_PS => "FALSE", -- Fine phase shift enable (TRUE/FALSE)
   CLKIN1_PERIOD => 0.0,            -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKIN2_PERIOD => 0.0,            -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKOUT0_DIVIDE_F => 1.0,         -- Divide amount for CLKOUT0
   CLKOUT0_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT0
   CLKOUT0_PHASE => 0.0,            -- Phase offset for CLKOUT0
   CLKOUT0_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT1_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT1_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT1_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT1_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT2_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT2_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT2_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT2_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT3_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT3_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT3_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT3_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT4_CASCADE => "FALSE",      -- Divide amount for CLKOUT (1-128)
   CLKOUT4_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT4_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT4_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT4_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT5_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT5_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT5_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT5_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   CLKOUT6_DIVIDE => 1,             -- Divide amount for CLKOUT (1-128)
   CLKOUT6_DUTY_CYCLE => 0.5,       -- Duty cycle for CLKOUT outputs (0.001-0.999).
   CLKOUT6_PHASE => 0.0,            -- Phase offset for CLKOUT outputs (-360.000-360.000).
   CLKOUT6_USE_FINE_PS => "FALSE",  -- Fine phase shift enable (TRUE/FALSE)
   COMPENSATION => "AUTO",          -- Clock input compensation
   DIVCLK_DIVIDE => 1,              -- Master division value
   IS_CLKFBIN_INVERTED => '0',      -- Optional inversion for CLKFBIN
   IS_CLKIN1_INVERTED => '0',       -- Optional inversion for CLKIN1
   IS_CLKIN2_INVERTED => '0',       -- Optional inversion for CLKIN2
   IS_CLKINSEL_INVERTED => '0',     -- Optional inversion for CLKINSEL
   IS_PSEN_INVERTED => '0',         -- Optional inversion for PSEN
   IS_PSINCDEC_INVERTED => '0',     -- Optional inversion for PSINCDEC
   IS_PWRDWN_INVERTED => '0',       -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',          -- Optional inversion for RST
   REF_JITTER1 => 0.0,              -- Reference input jitter in UI (0.000-0.999).
   REF_JITTER2 => 0.0,              -- Reference input jitter in UI (0.000-0.999).
   SS_EN => "FALSE",                -- Enables spread spectrum
   SS_MODE => "CENTER_HIGH",        -- Spread spectrum frequency deviation and the spread type
   SS_MOD_PERIOD => 10000,          -- Spread spectrum modulation period (ns)
   STARTUP_WAIT => "FALSE"          -- Delays DONE until MMCM is locked
)
port map (
   CDDCDONE => CDDCDONE,         -- 1-bit output: Clock dynamic divide done
   CLKFBOUT => CLKFBOUT,         -- 1-bit output: Feedback clock
   CLKFBOUTB => CLKFBOUTB,       -- 1-bit output: Inverted CLKFBOUT
   CLKFBSTOPPED => CLKFBSTOPPED, -- 1-bit output: Feedback clock stopped
   CLKINSTOPPED => CLKINSTOPPED, -- 1-bit output: Input clock stopped
   CLKOUT0 => CLKOUT0,           -- 1-bit output: CLKOUT0
   CLKOUT0B => CLKOUT0B,         -- 1-bit output: Inverted CLKOUT0
   CLKOUT1 => CLKOUT1,           -- 1-bit output: CLKOUT1
   CLKOUT1B => CLKOUT1B,         -- 1-bit output: Inverted CLKOUT1
   CLKOUT2 => CLKOUT2,           -- 1-bit output: CLKOUT2
   CLKOUT2B => CLKOUT2B,         -- 1-bit output: Inverted CLKOUT2
   CLKOUT3 => CLKOUT3,           -- 1-bit output: CLKOUT3
   CLKOUT3B => CLKOUT3B,         -- 1-bit output: Inverted CLKOUT3
   CLKOUT4 => CLKOUT4,           -- 1-bit output: CLKOUT4
   CLKOUT5 => CLKOUT5,           -- 1-bit output: CLKOUT5
   CLKOUT6 => CLKOUT6,           -- 1-bit output: CLKOUT6
   DO => DO,                     -- 16-bit output: DRP data output
   DRDY => DRDY,                 -- 1-bit output: DRP ready
   LOCKED => LOCKED,             -- 1-bit output: LOCK
   PSDONE => PSDONE,             -- 1-bit output: Phase shift done
   CDDCREQ => CDDCREQ,           -- 1-bit input: Request to dynamic divide clock
   CLKFBIN => CLKFBIN,           -- 1-bit input: Feedback clock
   CLKIN1 => CLKIN1,             -- 1-bit input: Primary clock
   CLKIN2 => CLKIN2,             -- 1-bit input: Secondary clock
   CLKINSEL => CLKINSEL,         -- 1-bit input: Clock select, High=CLKIN1 Low=CLKIN2
   DADDR => DADDR,               -- 7-bit input: DRP address
   DCLK => DCLK,                 -- 1-bit input: DRP clock
   DEN => DEN,                   -- 1-bit input: DRP enable
   DI => DI,                     -- 16-bit input: DRP data input
   DWE => DWE,                   -- 1-bit input: DRP write enable
   PSCLK => PSCLK,               -- 1-bit input: Phase shift clock
   PSEN => PSEN,                 -- 1-bit input: Phase shift enable
   PSINCDEC => PSINCDEC,         -- 1-bit input: Phase shift increment/decrement
   PWRDWN => PWRDWN,             -- 1-bit input: Power-down
   RST => RST                    -- 1-bit input: Reset
);

-- End of MMCME4_ADV_inst instantiation
