-- MMCME5: Mixed Mode Clock Manager (MMCM)
--         Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

MMCME5_inst : MMCME5
generic map (
   BANDWIDTH => "OPTIMIZED",         -- HIGH, LOW, OPTIMIZED
   CLKFBOUT_FRACT => 0,              -- 6-bit fraction M feedback divider (0-63)
   CLKFBOUT_MULT => 42,              -- Multiply value for all CLKOUT, (4-432)
   CLKFBOUT_PHASE => 0.0,            -- Phase offset in degrees of CLKFB
   CLKIN1_PERIOD => 0.0,             -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKIN2_PERIOD => 0.0,             -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKOUT0_DIVIDE => 2,              -- Divide amount for CLKOUT0 (2-511)
   CLKOUT0_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT0
   CLKOUT0_PHASE => 0.0,             -- Phase offset for CLKOUT0
   CLKOUT0_PHASE_CTRL => "00",       -- CLKOUT0 fine phase shift or deskew select (0-11)
   CLKOUT1_DIVIDE => 2,              -- Divide amount for CLKOUT1 (2-511)
   CLKOUT1_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT1
   CLKOUT1_PHASE => 0.0,             -- Phase offset for CLKOUT1
   CLKOUT1_PHASE_CTRL => "00",       -- CLKOUT1 fine phase shift or deskew select (0-11)
   CLKOUT2_DIVIDE => 2,              -- Divide amount for CLKOUT2 (2-511)
   CLKOUT2_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT2
   CLKOUT2_PHASE => 0.0,             -- Phase offset for CLKOUT2
   CLKOUT2_PHASE_CTRL => "00",       -- CLKOUT2 fine phase shift or deskew select (0-11)
   CLKOUT3_DIVIDE => 2,              -- Divide amount for CLKOUT3 (2-511)
   CLKOUT3_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT3
   CLKOUT3_PHASE => 0.0,             -- Phase offset for CLKOUT3
   CLKOUT3_PHASE_CTRL => "00",       -- CLKOUT3 fine phase shift or deskew select (0-11)
   CLKOUT4_DIVIDE => 2,              -- Divide amount for CLKOUT4 (2-511)
   CLKOUT4_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT4
   CLKOUT4_PHASE => 0.0,             -- Phase offset for CLKOUT4
   CLKOUT4_PHASE_CTRL => "00",       -- CLKOUT4 fine phase shift or deskew select (0-11)
   CLKOUT5_DIVIDE => 2,              -- Divide amount for CLKOUT5 (2-511)
   CLKOUT5_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT5
   CLKOUT5_PHASE => 0.0,             -- Phase offset for CLKOUT5
   CLKOUT5_PHASE_CTRL => "00",       -- CLKOUT5 fine phase shift or deskew select (0-11)
   CLKOUT6_DIVIDE => 2,              -- Divide amount for CLKOUT6 (2-511)
   CLKOUT6_DUTY_CYCLE => 0.5,        -- Duty cycle for CLKOUT6
   CLKOUT6_PHASE => 0.0,             -- Phase offset for CLKOUT6
   CLKOUT6_PHASE_CTRL => "00",       -- CLKOUT6 fine phase shift or deskew select (0-11)
   CLKOUTFB_PHASE_CTRL => "00",      -- CLKFBOUT fine phase shift or deskew select (0-11)
   COMPENSATION => "AUTO",           -- Clock input compensation
   DESKEW_DELAY1 => 0,               -- Deskew optional programmable delay
   DESKEW_DELAY2 => 0,               -- Deskew optional programmable delay
   DESKEW_DELAY_EN1 => "FALSE",      -- Enable deskew optional programmable delay
   DESKEW_DELAY_EN2 => "FALSE",      -- Enable deskew optional programmable delay
   DESKEW_DELAY_PATH1 => "FALSE",    -- Select CLKIN1_DESKEW (TRUE) or CLKFB1_DESKEW (FALSE)
   DESKEW_DELAY_PATH2 => "FALSE",    -- Select CLKIN2_DESKEW (TRUE) or CLKFB2_DESKEW (FALSE)
   DIVCLK_DIVIDE => 1,               -- Master division value
   IS_CLKFB1_DESKEW_INVERTED => '0', -- Optional inversion for CLKFB1_DESKEW
   IS_CLKFB2_DESKEW_INVERTED => '0', -- Optional inversion for CLKFB2_DESKEW
   IS_CLKFBIN_INVERTED => '0',       -- Optional inversion for CLKFBIN
   IS_CLKIN1_DESKEW_INVERTED => '0', -- Optional inversion for CLKIN1_DESKEW
   IS_CLKIN1_INVERTED => '0',        -- Optional inversion for CLKIN1
   IS_CLKIN2_DESKEW_INVERTED => '0', -- Optional inversion for CLKIN2_DESKEW
   IS_CLKIN2_INVERTED => '0',        -- Optional inversion for CLKIN2
   IS_CLKINSEL_INVERTED => '0',      -- Optional inversion for CLKINSEL
   IS_PSEN_INVERTED => '0',          -- Optional inversion for PSEN
   IS_PSINCDEC_INVERTED => '0',      -- Optional inversion for PSINCDEC
   IS_PWRDWN_INVERTED => '0',        -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',           -- Optional inversion for RST
   LOCK_WAIT => "FALSE",             -- Lock wait
   REF_JITTER1 => 0.0,               -- Reference input jitter in UI (0.000-0.200).
   REF_JITTER2 => 0.0,               -- Reference input jitter in UI (0.000-0.200).
   SS_EN => "FALSE",                 -- Enables spread spectrum
   SS_MODE => "CENTER_HIGH",         -- Spread spectrum frequency deviation and the spread type
   SS_MOD_PERIOD => 10000            -- Spread spectrum modulation period (ns)
)
port map (
   CLKFBOUT => CLKFBOUT,             -- 1-bit output: Feedback clock
   CLKFBSTOPPED => CLKFBSTOPPED,     -- 1-bit output: Feedback clock stopped
   CLKINSTOPPED => CLKINSTOPPED,     -- 1-bit output: Input clock stopped
   CLKOUT0 => CLKOUT0,               -- 1-bit output: CLKOUT0
   CLKOUT1 => CLKOUT1,               -- 1-bit output: CLKOUT1
   CLKOUT2 => CLKOUT2,               -- 1-bit output: CLKOUT2
   CLKOUT3 => CLKOUT3,               -- 1-bit output: CLKOUT3
   CLKOUT4 => CLKOUT4,               -- 1-bit output: CLKOUT4
   CLKOUT5 => CLKOUT5,               -- 1-bit output: CLKOUT5
   CLKOUT6 => CLKOUT6,               -- 1-bit output: CLKOUT6
   DO => DO,                         -- 16-bit output: DRP data output
   DRDY => DRDY,                     -- 1-bit output: DRP ready
   LOCKED => LOCKED,                 -- 1-bit output: LOCK
   LOCKED1_DESKEW => LOCKED1_DESKEW, -- 1-bit output: LOCK DESKEW PD1
   LOCKED2_DESKEW => LOCKED2_DESKEW, -- 1-bit output: LOCK DESKEW PD2
   LOCKED_FB => LOCKED_FB,           -- 1-bit output: LOCK FEEDBACK
   PSDONE => PSDONE,                 -- 1-bit output: Phase shift done
   CLKFB1_DESKEW => CLKFB1_DESKEW,   -- 1-bit input: Secondary clock input to PD1
   CLKFB2_DESKEW => CLKFB2_DESKEW,   -- 1-bit input: Secondary clock input to PD2
   CLKFBIN => CLKFBIN,               -- 1-bit input: Feedback clock
   CLKIN1 => CLKIN1,                 -- 1-bit input: Primary clock
   CLKIN1_DESKEW => CLKIN1_DESKEW,   -- 1-bit input: Primary clock input to PD1
   CLKIN2 => CLKIN2,                 -- 1-bit input: Secondary clock
   CLKIN2_DESKEW => CLKIN2_DESKEW,   -- 1-bit input: Primary clock input to PD2
   CLKINSEL => CLKINSEL,             -- 1-bit input: Clock select, High=CLKIN1 Low=CLKIN2
   DADDR => DADDR,                   -- 7-bit input: DRP address
   DCLK => DCLK,                     -- 1-bit input: DRP clock
   DEN => DEN,                       -- 1-bit input: DRP enable
   DI => DI,                         -- 16-bit input: DRP data input
   DWE => DWE,                       -- 1-bit input: DRP write enable
   PSCLK => PSCLK,                   -- 1-bit input: Phase shift clock
   PSEN => PSEN,                     -- 1-bit input: Phase shift enable
   PSINCDEC => PSINCDEC,             -- 1-bit input: Phase shift increment/decrement
   PWRDWN => PWRDWN,                 -- 1-bit input: Power-down
   RST => RST                        -- 1-bit input: Reset
);

-- End of MMCME5_inst instantiation
