-- PLLE3_BASE: Base Phase-Locked Loop (PLL)
--             Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

PLLE3_BASE_inst : PLLE3_BASE
generic map (
   CLKFBOUT_MULT => 5,         -- Multiply value for all CLKOUT, (1-19)
   CLKFBOUT_PHASE => 0.0,      -- Phase offset in degrees of CLKFB, (-360.000-360.000)
   CLKIN_PERIOD => 0.0,        -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   -- CLKOUT0 Attributes: Divide, Phase and Duty Cycle for the CLKOUT0 output
   CLKOUT0_DIVIDE => 1,        -- Divide amount for CLKOUT0 (1-128)
   CLKOUT0_DUTY_CYCLE => 0.5,  -- Duty cycle for CLKOUT0 (0.001-0.999)
   CLKOUT0_PHASE => 0.0,       -- Phase offset for CLKOUT0 (-360.000-360.000)
   -- CLKOUT1 Attributes: Divide, Phase and Duty Cycle for the CLKOUT1 output
   CLKOUT1_DIVIDE => 1,        -- Divide amount for CLKOUT1 (1-128)
   CLKOUT1_DUTY_CYCLE => 0.5,  -- Duty cycle for CLKOUT1 (0.001-0.999)
   CLKOUT1_PHASE => 0.0,       -- Phase offset for CLKOUT1 (-360.000-360.000)
   CLKOUTPHY_MODE => "VCO_2X", -- Frequency of the CLKOUTPHY (VCO, VCO_2X, VCO_HALF)
   DIVCLK_DIVIDE => 1,         -- Master division value, (1-15)
   -- Programmable Inversion Attributes: Specifies built-in programmable inversion on specific pins
   IS_CLKFBIN_INVERTED => '0', -- Optional inversion for CLKFBIN
   IS_CLKIN_INVERTED => '0',   -- Optional inversion for CLKIN
   IS_PWRDWN_INVERTED => '0',  -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',     -- Optional inversion for RST
   REF_JITTER => 0.0,          -- Reference input jitter in UI (0.000-0.999)
   STARTUP_WAIT => "FALSE"     -- Delays DONE until PLL is locked (FALSE, TRUE)
)
port map (
   -- Clock Outputs outputs: User configurable clock outputs
   CLKOUT0 => CLKOUT0,         -- 1-bit output: General Clock output
   CLKOUT0B => CLKOUT0B,       -- 1-bit output: Inverted CLKOUT0
   CLKOUT1 => CLKOUT1,         -- 1-bit output: General Clock output
   CLKOUT1B => CLKOUT1B,       -- 1-bit output: Inverted CLKOUT1
   CLKOUTPHY => CLKOUTPHY,     -- 1-bit output: Bitslice clock
   -- Feedback Clocks outputs: Clock feedback ports
   CLKFBOUT => CLKFBOUT,       -- 1-bit output: Feedback clock
   LOCKED => LOCKED,           -- 1-bit output: LOCK
   CLKIN => CLKIN,             -- 1-bit input: Input clock
   -- Control Ports inputs: PLL control ports
   CLKOUTPHYEN => CLKOUTPHYEN, -- 1-bit input: CLKOUTPHY enable
   PWRDWN => PWRDWN,           -- 1-bit input: Power-down
   RST => RST,                 -- 1-bit input: Reset
   -- Feedback Clocks inputs: Clock feedback ports
   CLKFBIN => CLKFBIN          -- 1-bit input: Feedback clock
);

-- End of PLLE3_BASE_inst instantiation
