-- PLLE4_BASE: Base Phase-Locked Loop (PLL)
--             Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

PLLE4_BASE_inst : PLLE4_BASE
generic map (
   CLKFBOUT_MULT => 5,         -- Multiply value for all CLKOUT
   CLKFBOUT_PHASE => 0.0,      -- Phase offset in degrees of CLKFB
   CLKIN_PERIOD => 0.0,        -- Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   CLKOUT0_DIVIDE => 1,        -- Divide amount for CLKOUT0
   CLKOUT0_DUTY_CYCLE => 0.5,  -- Duty cycle for CLKOUT0
   CLKOUT0_PHASE => 0.0,       -- Phase offset for CLKOUT0
   CLKOUT1_DIVIDE => 1,        -- Divide amount for CLKOUT1
   CLKOUT1_DUTY_CYCLE => 0.5,  -- Duty cycle for CLKOUT1
   CLKOUT1_PHASE => 0.0,       -- Phase offset for CLKOUT1
   CLKOUTPHY_MODE => "VCO_2X", -- Frequency of the CLKOUTPHY
   DIVCLK_DIVIDE => 1,         -- Master division value
   IS_CLKFBIN_INVERTED => '0', -- Optional inversion for CLKFBIN
   IS_CLKIN_INVERTED => '0',   -- Optional inversion for CLKIN
   IS_PWRDWN_INVERTED => '0',  -- Optional inversion for PWRDWN
   IS_RST_INVERTED => '0',     -- Optional inversion for RST
   REF_JITTER => 0.0,          -- Reference input jitter in UI
   STARTUP_WAIT => "FALSE"     -- Delays DONE until PLL is locked
)
port map (
   CLKFBOUT => CLKFBOUT,       -- 1-bit output: Feedback clock
   CLKOUT0 => CLKOUT0,         -- 1-bit output: General Clock output
   CLKOUT0B => CLKOUT0B,       -- 1-bit output: Inverted CLKOUT0
   CLKOUT1 => CLKOUT1,         -- 1-bit output: General Clock output
   CLKOUT1B => CLKOUT1B,       -- 1-bit output: Inverted CLKOUT1
   CLKOUTPHY => CLKOUTPHY,     -- 1-bit output: Bitslice clock
   LOCKED => LOCKED,           -- 1-bit output: LOCK
   CLKFBIN => CLKFBIN,         -- 1-bit input: Feedback clock
   CLKIN => CLKIN,             -- 1-bit input: Input clock
   CLKOUTPHYEN => CLKOUTPHYEN, -- 1-bit input: CLKOUTPHY enable
   PWRDWN => PWRDWN,           -- 1-bit input: Power-down
   RST => RST                  -- 1-bit input: Reset
);

-- End of PLLE4_BASE_inst instantiation
