-- URAM288_BASE: 288K-bit High-Density Base Memory Building Block
--               Versal AI Core Series
-- Xilinx HDL Language Template, version 2025.1

URAM288_BASE_inst : URAM288_BASE
generic map (
   AUTO_SLEEP_LATENCY => 8,            -- Latency requirement to enter sleep mode
   AVG_CONS_INACTIVE_CYCLES => 10,     -- Average consecutive inactive cycles when is SLEEP mode for power estimation
   BWE_MODE_A => "PARITY_INTERLEAVED", -- Port A Byte write control
   BWE_MODE_B => "PARITY_INTERLEAVED", -- Port B Byte write control
   EN_AUTO_SLEEP_MODE => "FALSE",      -- Enable to automatically enter sleep mode
   EN_ECC_RD_A => "FALSE",             -- Port A ECC encoder
   EN_ECC_RD_B => "FALSE",             -- Port B ECC encoder
   EN_ECC_WR_A => "FALSE",             -- Port A ECC decoder
   EN_ECC_WR_B => "FALSE",             -- Port B ECC decoder
   IREG_PRE_A => "FALSE",              -- Optional Port A input pipeline registers
   IREG_PRE_B => "FALSE",              -- Optional Port B input pipeline registers
   IS_CLK_INVERTED => '0',             -- Optional inverter for CLK
   IS_EN_A_INVERTED => '0',            -- Optional inverter for Port A enable
   IS_EN_B_INVERTED => '0',            -- Optional inverter for Port B enable
   IS_RDB_WR_A_INVERTED => '0',        -- Optional inverter for Port A read/write select
   IS_RDB_WR_B_INVERTED => '0',        -- Optional inverter for Port B read/write select
   IS_RST_A_INVERTED => '0',           -- Optional inverter for Port A reset
   IS_RST_B_INVERTED => '0',           -- Optional inverter for Port B reset
   OREG_A => "FALSE",                  -- Optional Port A output pipeline registers
   OREG_B => "FALSE",                  -- Optional Port B output pipeline registers
   OREG_ECC_A => "FALSE",              -- Port A ECC decoder output
   OREG_ECC_B => "FALSE",              -- Port B output ECC decoder
   RST_MODE_A => "SYNC",               -- Port A reset mode
   RST_MODE_B => "SYNC",               -- Port B reset mode
   USE_EXT_CE_A => "FALSE",            -- Enable Port A external CE inputs for output registers
   USE_EXT_CE_B => "FALSE"             -- Enable Port B external CE inputs for output registers
)
port map (
   DBITERR_A => DBITERR_A,               -- 1-bit output: Port A double-bit error flag status
   DBITERR_B => DBITERR_B,               -- 1-bit output: Port B double-bit error flag status
   DOUT_A => DOUT_A,                     -- 72-bit output: Port A read data output
   DOUT_B => DOUT_B,                     -- 72-bit output: Port B read data output
   SBITERR_A => SBITERR_A,               -- 1-bit output: Port A single-bit error flag status
   SBITERR_B => SBITERR_B,               -- 1-bit output: Port B single-bit error flag status
   ADDR_A => ADDR_A,                     -- 23-bit input: Port A address
   ADDR_B => ADDR_B,                     -- 23-bit input: Port B address
   BWE_A => BWE_A,                       -- 9-bit input: Port A Byte-write enable
   BWE_B => BWE_B,                       -- 9-bit input: Port B Byte-write enable
   CLK => CLK,                           -- 1-bit input: Clock source
   DIN_A => DIN_A,                       -- 72-bit input: Port A write data input
   DIN_B => DIN_B,                       -- 72-bit input: Port B write data input
   EN_A => EN_A,                         -- 1-bit input: Port A enable
   EN_B => EN_B,                         -- 1-bit input: Port B enable
   INJECT_DBITERR_A => INJECT_DBITERR_A, -- 1-bit input: Port A double-bit error injection
   INJECT_DBITERR_B => INJECT_DBITERR_B, -- 1-bit input: Port B double-bit error injection
   INJECT_SBITERR_A => INJECT_SBITERR_A, -- 1-bit input: Port A single-bit error injection
   INJECT_SBITERR_B => INJECT_SBITERR_B, -- 1-bit input: Port B single-bit error injection
   OREG_CE_A => OREG_CE_A,               -- 1-bit input: Port A output register clock enable
   OREG_CE_B => OREG_CE_B,               -- 1-bit input: Port B output register clock enable
   OREG_ECC_CE_A => OREG_ECC_CE_A,       -- 1-bit input: Port A ECC decoder output register clock enable
   OREG_ECC_CE_B => OREG_ECC_CE_B,       -- 1-bit input: Port B ECC decoder output register clock enable
   RDB_WR_A => RDB_WR_A,                 -- 1-bit input: Port A read/write select
   RDB_WR_B => RDB_WR_B,                 -- 1-bit input: Port B read/write select
   RST_A => RST_A,                       -- 1-bit input: Port A asynchronous or synchronous reset for output registers
   RST_B => RST_B,                       -- 1-bit input: Port B asynchronous or synchronous reset for output registers
   SLEEP => SLEEP                        -- 1-bit input: Dynamic power gating control
);

-- End of URAM288_BASE_inst instantiation
