// MMCME4_BASE: Base Mixed Mode Clock Manager (MMCM)
//              Versal AI Core Series
// Xilinx HDL Language Template, version 2025.1

MMCME4_BASE #(
   .BANDWIDTH("OPTIMIZED"),    // Jitter programming
   .CLKFBOUT_MULT_F(5.0),      // Multiply value for all CLKOUT
   .CLKFBOUT_PHASE(0.0),       // Phase offset in degrees of CLKFB
   .CLKIN1_PERIOD(0.0),        // Input clock period in ns to ps resolution (i.e., 33.333 is 30 MHz).
   .CLKOUT0_DIVIDE_F(1.0),     // Divide amount for CLKOUT0
   .CLKOUT0_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT0
   .CLKOUT0_PHASE(0.0),        // Phase offset for CLKOUT0
   .CLKOUT1_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT1_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT1_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT2_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT2_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT2_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT3_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT3_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT3_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT4_CASCADE("FALSE"),  // Divide amount for CLKOUT (1-128)
   .CLKOUT4_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT4_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT4_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT5_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT5_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT5_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT6_DIVIDE(1),         // Divide amount for CLKOUT (1-128)
   .CLKOUT6_DUTY_CYCLE(0.5),   // Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT6_PHASE(0.0),        // Phase offset for CLKOUT outputs (-360.000-360.000).
   .DIVCLK_DIVIDE(1),          // Master division value
   .IS_CLKFBIN_INVERTED(1'b0), // Optional inversion for CLKFBIN
   .IS_CLKIN1_INVERTED(1'b0),  // Optional inversion for CLKIN1
   .IS_PWRDWN_INVERTED(1'b0),  // Optional inversion for PWRDWN
   .IS_RST_INVERTED(1'b0),     // Optional inversion for RST
   .REF_JITTER1(0.0),          // Reference input jitter in UI (0.000-0.999).
   .STARTUP_WAIT("FALSE")      // Delays DONE until MMCM is locked
)
MMCME4_BASE_inst (
   .CLKFBOUT(CLKFBOUT),   // 1-bit output: Feedback clock pin to the MMCM
   .CLKFBOUTB(CLKFBOUTB), // 1-bit output: Inverted CLKFBOUT
   .CLKOUT0(CLKOUT0),     // 1-bit output: CLKOUT0
   .CLKOUT0B(CLKOUT0B),   // 1-bit output: Inverted CLKOUT0
   .CLKOUT1(CLKOUT1),     // 1-bit output: CLKOUT1
   .CLKOUT1B(CLKOUT1B),   // 1-bit output: Inverted CLKOUT1
   .CLKOUT2(CLKOUT2),     // 1-bit output: CLKOUT2
   .CLKOUT2B(CLKOUT2B),   // 1-bit output: Inverted CLKOUT2
   .CLKOUT3(CLKOUT3),     // 1-bit output: CLKOUT3
   .CLKOUT3B(CLKOUT3B),   // 1-bit output: Inverted CLKOUT3
   .CLKOUT4(CLKOUT4),     // 1-bit output: CLKOUT4
   .CLKOUT5(CLKOUT5),     // 1-bit output: CLKOUT5
   .CLKOUT6(CLKOUT6),     // 1-bit output: CLKOUT6
   .LOCKED(LOCKED),       // 1-bit output: LOCK
   .CLKFBIN(CLKFBIN),     // 1-bit input: Feedback clock pin to the MMCM
   .CLKIN1(CLKIN1),       // 1-bit input: Primary clock
   .PWRDWN(PWRDWN),       // 1-bit input: Power-down
   .RST(RST)              // 1-bit input: Reset
);

// End of MMCME4_BASE_inst instantiation
