// RAM32M16: 32-deep by 16-wide Multi Port LUT RAM (Mapped to eight LUT6s)
//           Versal AI Core Series
// Xilinx HDL Language Template, version 2025.1

RAM32M16 #(
   .INIT_A(64'h0000000000000000), // Initial contents of A Port
   .INIT_B(64'h0000000000000000), // Initial contents of B Port
   .INIT_C(64'h0000000000000000), // Initial contents of C Port
   .INIT_D(64'h0000000000000000), // Initial contents of D Port
   .INIT_E(64'h0000000000000000), // Initial contents of E Port
   .INIT_F(64'h0000000000000000), // Initial contents of F Port
   .INIT_G(64'h0000000000000000), // Initial contents of G Port
   .INIT_H(64'h0000000000000000), // Initial contents of H Port
   .IS_WCLK_INVERTED(1'b0)        // Specifies active high/low WCLK
) RAM32M16_inst (
   .DOA(DOA),     // Read port A 2-bit output
   .DOB(DOB),     // Read port B 2-bit output
   .DOC(DOC),     // Read port C 2-bit output
   .DOD(DOD),     // Read port D 2-bit output
   .DOE(DOE),     // Read port E 2-bit output
   .DOF(DOF),     // Read port F 2-bit output
   .DOG(DOG),     // Read port G 2-bit output
   .DOH(DOH),     // Read/write port H 2-bit output
   .ADDRA(ADDRA), // Read port A 5-bit address input
   .ADDRB(ADDRB), // Read port B 5-bit address input
   .ADDRC(ADDRC), // Read port C 5-bit address input
   .ADDRD(ADDRD), // Read port D 5-bit address input
   .ADDRE(ADDRE), // Read port E 5-bit address input
   .ADDRF(ADDRF), // Read port F 5-bit address input
   .ADDRG(ADDRG), // Read port G 5-bit address input
   .ADDRH(ADDRH), // Read/write port H 5-bit address input
   .DIA(DIA),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRA
   .DIB(DIB),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRB
   .DIC(DIC),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRC
   .DID(DID),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRD
   .DIE(DIE),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRE
   .DIF(DIF),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRF
   .DIG(DIG),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRG
   .DIH(DIH),     // RAM 2-bit data write input addressed by ADDRH,
                  //   read addressed by ADDRH
   .WCLK(WCLK),   // Write clock input
   .WE(WE)        // Write enable input
);

// End of RAM32M16_inst instantiation
