// XPLL: XPIO PLL
//       Versal AI Core Series
// Xilinx HDL Language Template, version 2025.1

XPLL #(
   .CLKFBOUT_MULT(42),               // Multiply value for all CLKOUT, (4-43)
   .CLKFBOUT_PHASE(0.0),             // Phase offset in degrees of CLKFB
   .CLKIN_PERIOD(0.0),               // Input clock period in ns to ps resolution (i.e. 33.333 is 30 MHz).
   .CLKOUT0_DIVIDE(2),               // Divide amount for CLKOUT0 (2-128)
   .CLKOUT0_DUTY_CYCLE(0.5),         // Duty cycle for CLKOUT0
   .CLKOUT0_PHASE(0.0),              // Phase offset for CLKOUT0
   .CLKOUT0_PHASE_CTRL(2'b00),       // CLKOUT0 fine phase shift or deskew select (0-11)
   .CLKOUT1_DIVIDE(2),               // Divide amount for CLKOUT1 (2-128)
   .CLKOUT1_DUTY_CYCLE(0.5),         // Duty cycle for CLKOUT1
   .CLKOUT1_PHASE(0.0),              // Phase offset for CLKOUT1
   .CLKOUT1_PHASE_CTRL(2'b00),       // CLKOUT1 fine phase shift or deskew select (0-11)
   .CLKOUT2_DIVIDE(2),               // Divide amount for CLKOUT2 (2-128)
   .CLKOUT2_DUTY_CYCLE(0.5),         // Duty cycle for CLKOUT2
   .CLKOUT2_PHASE(0.0),              // Phase offset for CLKOUT2
   .CLKOUT2_PHASE_CTRL(2'b00),       // CLKOUT2 fine phase shift or deskew select (0-11)
   .CLKOUT3_DIVIDE(2),               // Divide amount for CLKOUT3 (2-128)
   .CLKOUT3_DUTY_CYCLE(0.5),         // Duty cycle for CLKOUT3
   .CLKOUT3_PHASE(0.0),              // Phase offset for CLKOUT3
   .CLKOUT3_PHASE_CTRL(2'b00),       // CLKOUT3 fine phase shift or deskew select (0-11)
   .CLKOUTPHY_CASCIN_EN(1'b0),       // XPLL CLKOUTPHY cascade input enable
   .CLKOUTPHY_CASCOUT_EN(1'b0),      // XPLL CLKOUTPHY cascade output enable
   .DESKEW2_MUXIN_SEL(1'b0),         // Deskew mux selection
   .DESKEW_DELAY1(0),                // Deskew optional programmable delay
   .DESKEW_DELAY2(0),                // Deskew optional programmable delay
   .DESKEW_DELAY_EN1("FALSE"),       // Enable deskew optional programmable delay
   .DESKEW_DELAY_EN2("FALSE"),       // Enable deskew optional programmable delay
   .DESKEW_DELAY_PATH1("FALSE"),     // Select CLKIN1_DESKEW (TRUE) or CLKFB1_DESKEW (FALSE)
   .DESKEW_DELAY_PATH2("FALSE"),     // Select CLKIN2_DESKEW (TRUE) or CLKFB2_DESKEW (FALSE)
   .DESKEW_MUXIN_SEL(1'b0),          // Deskew mux selection
   .DIVCLK_DIVIDE(1),                // Master division value
   .IS_CLKFB1_DESKEW_INVERTED(1'b0), // Optional inversion for CLKFB1_DESKEW
   .IS_CLKFB2_DESKEW_INVERTED(1'b0), // Optional inversion for CLKFB2_DESKEW
   .IS_CLKIN1_DESKEW_INVERTED(1'b0), // Optional inversion for CLKIN1_DESKEW
   .IS_CLKIN2_DESKEW_INVERTED(1'b0), // Optional inversion for CLKIN2_DESKEW
   .IS_CLKIN_INVERTED(1'b0),         // Optional inversion for CLKIN
   .IS_PSEN_INVERTED(1'b0),          // Optional inversion for PSEN
   .IS_PSINCDEC_INVERTED(1'b0),      // Optional inversion for PSINCDEC
   .IS_PWRDWN_INVERTED(1'b0),        // Optional inversion for PWRDWN
   .IS_RST_INVERTED(1'b0),           // Optional inversion for RST
   .LOCK_WAIT("FALSE"),              // Lock wait
   .REF_JITTER(0.0),                 // Reference input jitter in UI (0.000-0.200).
   .SIM_ADJ_CLK0_CASCADE("FALSE"),   // Simulation only attribute to reduce CLKOUT0 skew when cascading (FALSE, TRUE)
   .XPLL_CONNECT_TO_NOCMC("NONE")    // XPLL driving the DDRMC
)
XPLL_inst (
   .CLKOUT0(CLKOUT0),                       // 1-bit output: CLKOUT0
   .CLKOUT1(CLKOUT1),                       // 1-bit output: CLKOUT1
   .CLKOUT2(CLKOUT2),                       // 1-bit output: CLKOUT2
   .CLKOUT3(CLKOUT3),                       // 1-bit output: CLKOUT3
   .CLKOUTPHY(CLKOUTPHY),                   // 1-bit output: XPHY Logic clock
   .CLKOUTPHY_CASC_OUT(CLKOUTPHY_CASC_OUT), // 1-bit output: XPLL CLKOUTPHY cascade output
   .DO(DO),                                 // 16-bit output: DRP data output
   .DRDY(DRDY),                             // 1-bit output: DRP ready
   .LOCKED(LOCKED),                         // 1-bit output: LOCK
   .LOCKED1_DESKEW(LOCKED1_DESKEW),         // 1-bit output: LOCK DESKEW PD1
   .LOCKED2_DESKEW(LOCKED2_DESKEW),         // 1-bit output: LOCK DESKEW PD2
   .LOCKED_FB(LOCKED_FB),                   // 1-bit output: LOCK FEEDBACK
   .PSDONE(PSDONE),                         // 1-bit output: Phase shift done
   .CLKFB1_DESKEW(CLKFB1_DESKEW),           // 1-bit input: Secondary clock input to PD1
   .CLKFB2_DESKEW(CLKFB2_DESKEW),           // 1-bit input: Secondary clock input to PD2
   .CLKIN(CLKIN),                           // 1-bit input: Primary clock
   .CLKIN1_DESKEW(CLKIN1_DESKEW),           // 1-bit input: Primary clock input to PD1
   .CLKIN2_DESKEW(CLKIN2_DESKEW),           // 1-bit input: Primary clock input to PD2
   .CLKOUTPHYEN(CLKOUTPHYEN),               // 1-bit input: CLKOUTPHY enable
   .CLKOUTPHY_CASC_IN(CLKOUTPHY_CASC_IN),   // 1-bit input: XPLL CLKOUTPHY cascade input
   .DADDR(DADDR),                           // 7-bit input: DRP address
   .DCLK(DCLK),                             // 1-bit input: DRP clock
   .DEN(DEN),                               // 1-bit input: DRP enable
   .DI(DI),                                 // 16-bit input: DRP data input
   .DWE(DWE),                               // 1-bit input: DRP write enable
   .PSCLK(PSCLK),                           // 1-bit input: Phase shift clock
   .PSEN(PSEN),                             // 1-bit input: Phase shift enable
   .PSINCDEC(PSINCDEC),                     // 1-bit input: Phase shift increment/decrement
   .PWRDWN(PWRDWN),                         // 1-bit input: Power-down
   .RST(RST)                                // 1-bit input: Reset
);

// End of XPLL_inst instantiation
