-- xpm_cdc_pulse: Pulse Transfer
-- Xilinx Parameterized Macro, version 2025.2

xpm_cdc_pulse_inst : xpm_cdc_pulse
generic map (
   DEST_SYNC_FF => 4,   -- DECIMAL; range: 2-10
   INIT_SYNC_FF => 0,   -- DECIMAL; 0=disable simulation init values, 1=enable simulation init values
   REG_OUTPUT => 0,     -- DECIMAL; 0=disable registered output, 1=enable registered output
   RST_USED => 1,       -- DECIMAL; 0=no reset, 1=implement reset
   SIM_ASSERT_CHK => 0  -- DECIMAL; 0=disable simulation messages, 1=enable simulation messages
)
port map (
   dest_pulse => dest_pulse, -- 1-bit output: Outputs a pulse the size of one dest_clk period when a pulse transfer is correctly initiated on
                             -- src_pulse input. This output is combinatorial unless REG_OUTPUT is set to 1.

   dest_clk => dest_clk,     -- 1-bit input: Destination clock.
   dest_rst => dest_rst,     -- 1-bit input: optional; required when RST_USED = 1
   src_clk => src_clk,       -- 1-bit input: Source clock.
   src_pulse => src_pulse,   -- 1-bit input: Rising edge of this signal initiates a pulse transfer to the destination clock domain. The minimum
                             -- gap between each pulse transfer must be at the minimum 2*(larger(src_clk period, dest_clk period)). This is
                             -- measured between the falling edge of a src_pulse to the rising edge of the next src_pulse. This minimum gap will
                             -- guarantee that each rising edge of src_pulse will generate a pulse the size of one dest_clk period in the
                             -- destination clock domain. When RST_USED = 1, pulse transfers will not be guaranteed while src_rst and/or dest_rst
                             -- are asserted.

   src_rst => src_rst        -- 1-bit input: optional; required when RST_USED = 1
);

-- End of xpm_cdc_pulse_inst instantiation
