-- xpm_fifo_axil: AXI Memory Mapped (AXI Lite) FIFO
-- Xilinx Parameterized Macro, version 2025.2

xpm_fifo_axil_inst : xpm_fifo_axil
generic map (
   AXI_ADDR_WIDTH => 32,            -- DECIMAL
   AXI_DATA_WIDTH => 32,            -- DECIMAL
   CASCADE_HEIGHT => 0,             -- DECIMAL
   CDC_SYNC_STAGES => 2,            -- DECIMAL
   CLOCKING_MODE => "common_clock", -- String
   ECC_MODE_RDCH => "no_ecc",       -- String
   ECC_MODE_WDCH => "no_ecc",       -- String
   EN_RESET_SYNCHRONIZER => 1,      -- DECIMAL; 0=disable synchronizer in the reset path, 1=enable synchronizer in the reset path
   EN_SIM_ASSERT_ERR => "warning",  -- String
   FIFO_DEPTH_RACH => 2048,         -- DECIMAL
   FIFO_DEPTH_RDCH => 2048,         -- DECIMAL
   FIFO_DEPTH_WACH => 2048,         -- DECIMAL
   FIFO_DEPTH_WDCH => 2048,         -- DECIMAL
   FIFO_DEPTH_WRCH => 2048,         -- DECIMAL
   FIFO_MEMORY_TYPE_RACH => "auto", -- String
   FIFO_MEMORY_TYPE_RDCH => "auto", -- String
   FIFO_MEMORY_TYPE_WACH => "auto", -- String
   FIFO_MEMORY_TYPE_WDCH => "auto", -- String
   FIFO_MEMORY_TYPE_WRCH => "auto", -- String
   PROG_EMPTY_THRESH_RDCH => 10,    -- DECIMAL
   PROG_EMPTY_THRESH_WDCH => 10,    -- DECIMAL
   PROG_FULL_THRESH_RDCH => 10,     -- DECIMAL
   PROG_FULL_THRESH_WDCH => 10,     -- DECIMAL
   RD_DATA_COUNT_WIDTH_RDCH => 1,   -- DECIMAL
   RD_DATA_COUNT_WIDTH_WDCH => 1,   -- DECIMAL
   SIM_ASSERT_CHK => 0,             -- DECIMAL; 0=disable simulation messages, 1=enable simulation messages
   USE_ADV_FEATURES_RDCH => "1000", -- String
   USE_ADV_FEATURES_WDCH => "1000", -- String
   WR_DATA_COUNT_WIDTH_RDCH => 1,   -- DECIMAL
   WR_DATA_COUNT_WIDTH_WDCH => 1    -- DECIMAL
)
port map (
   dbiterr_rdch => dbiterr_rdch,             -- 1-bit output: Double Bit Error- Indicates that the ECC decoder detected a double-bit error and
                                             -- data in the FIFO core is corrupted.

   dbiterr_wdch => dbiterr_wdch,             -- 1-bit output: Double Bit Error- Indicates that the ECC decoder detected a double-bit error and
                                             -- data in the FIFO core is corrupted.

   m_axi_araddr => m_axi_araddr,             -- AXI_ADDR_WIDTH-bit output: ARADDR: The read address bus gives the initial address of a read burst
                                             -- transaction. Only the start address of the burst is provided and the control signals that are
                                             -- issued alongside the address detail how the address is calculated for the remaining transfers in
                                             -- the burst.

   m_axi_arprot => m_axi_arprot,             -- 2-bit output: ARPROT: Indicates the normal, privileged, or secure protection level of the
                                             -- transaction and whether the transaction is a data access or an instruction access.

   m_axi_arvalid => m_axi_arvalid,           -- 1-bit output: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both ARVALID and ARREADY are asserted

   m_axi_awaddr => m_axi_awaddr,             -- AXI_ADDR_WIDTH-bit output: AWADDR: The write address bus gives the address of the first transfer
                                             -- in a write burst transaction. The associated control signals are used to determine the addresses
                                             -- of the remaining transfers in the burst.

   m_axi_awprot => m_axi_awprot,             -- 2-bit output: AWPROT: Indicates the normal, privileged, or secure protection level of the
                                             -- transaction and whether the transaction is a data access or an instruction access.

   m_axi_awvalid => m_axi_awvalid,           -- 1-bit output: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both AWVALID and AWREADY are asserted

   m_axi_bready => m_axi_bready,             -- 1-bit output: BREADY: Indicates that the master can accept a transfer in the current cycle.
   m_axi_rready => m_axi_rready,             -- 1-bit output: RREADY: Indicates that the master can accept a transfer in the current cycle.
   m_axi_wdata => m_axi_wdata,               -- AXI_DATA_WIDTH-bit output: WDATA: The primary payload that is used to provide the data that is
                                             -- passing across the interface. The width of the data payload is an integer number of bytes.

   m_axi_wstrb => m_axi_wstrb,               -- AXI_DATA_WIDTH/8-bit output: WSTRB: The byte qualifier that indicates whether the content of the
                                             -- associated byte of TDATA is processed as a data byte or a position byte. For a 64-bit DATA, bit 0
                                             -- corresponds to the least significant byte on DATA, and bit 0 corresponds to the least significant
                                             -- byte on DATA, and bit 7 corresponds to the most significant byte. For example: STROBE[0] = 1b,
                                             -- DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is not valid

   m_axi_wvalid => m_axi_wvalid,             -- 1-bit output: WVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both WVALID and WREADY are asserted

   prog_empty_rdch => prog_empty_rdch,       -- 1-bit output: Programmable Empty- This signal is asserted when the number of words in the Read
                                             -- Data Channel FIFO is less than or equal to the programmable empty threshold value. It is
                                             -- de-asserted when the number of words in the Read Data Channel FIFO exceeds the programmable empty
                                             -- threshold value.

   prog_empty_wdch => prog_empty_wdch,       -- 1-bit output: Programmable Empty- This signal is asserted when the number of words in the Write
                                             -- Data Channel FIFO is less than or equal to the programmable empty threshold value. It is
                                             -- de-asserted when the number of words in the Write Data Channel FIFO exceeds the programmable empty
                                             -- threshold value.

   prog_full_rdch => prog_full_rdch,         -- 1-bit output: Programmable Full: This signal is asserted when the number of words in the Read Data
                                             -- Channel FIFO is greater than or equal to the programmable full threshold value. It is de-asserted
                                             -- when the number of words in the Read Data Channel FIFO is less than the programmable full
                                             -- threshold value.

   prog_full_wdch => prog_full_wdch,         -- 1-bit output: Programmable Full: This signal is asserted when the number of words in the Write
                                             -- Data Channel FIFO is greater than or equal to the programmable full threshold value. It is
                                             -- de-asserted when the number of words in the Write Data Channel FIFO is less than the programmable
                                             -- full threshold value.

   rd_data_count_rdch => rd_data_count_rdch, -- RD_DATA_COUNT_WIDTH_RDCH-bit output: Read Data Count- This bus indicates the number of words
                                             -- available for reading in the Read Data Channel FIFO.

   rd_data_count_wdch => rd_data_count_wdch, -- RD_DATA_COUNT_WIDTH_WDCH-bit output: Read Data Count- This bus indicates the number of words
                                             -- available for reading in the Write Data Channel FIFO.

   s_axi_arready => s_axi_arready,           -- 1-bit output: ARREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_awready => s_axi_awready,           -- 1-bit output: AWREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_bresp => s_axi_bresp,               -- 2-bit output: BRESP: Write Response. Indicates the status of the write transaction. The allowable
                                             -- responses are OKAY, EXOKAY, SLVERR, and DECERR.

   s_axi_bvalid => s_axi_bvalid,             -- 1-bit output: BVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both BVALID and BREADY are asserted

   s_axi_rdata => s_axi_rdata,               -- AXI_DATA_WIDTH-bit output: RDATA: The primary payload that is used to provide the data that is
                                             -- passing across the interface. The width of the data payload is an integer number of bytes.

   s_axi_rresp => s_axi_rresp,               -- 2-bit output: RRESP: Indicates the status of the read transfer. The allowable responses are OKAY,
                                             -- EXOKAY, SLVERR, and DECERR.

   s_axi_rvalid => s_axi_rvalid,             -- 1-bit output: RVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both RVALID and RREADY are asserted

   s_axi_wready => s_axi_wready,             -- 1-bit output: WREADY: Indicates that the slave can accept a transfer in the current cycle.
   sbiterr_rdch => sbiterr_rdch,             -- 1-bit output: Single Bit Error- Indicates that the ECC decoder detected and fixed a single-bit
                                             -- error.

   sbiterr_wdch => sbiterr_wdch,             -- 1-bit output: Single Bit Error- Indicates that the ECC decoder detected and fixed a single-bit
                                             -- error.

   wr_data_count_rdch => wr_data_count_rdch, -- WR_DATA_COUNT_WIDTH_RDCH-bit output: Write Data Count: This bus indicates the number of words
                                             -- written into the Read Data Channel FIFO.

   wr_data_count_wdch => wr_data_count_wdch, -- WR_DATA_COUNT_WIDTH_WDCH-bit output: Write Data Count: This bus indicates the number of words
                                             -- written into the Write Data Channel FIFO.

   injectdbiterr_rdch => injectdbiterr_rdch, -- 1-bit input: Double Bit Error Injection- Injects a double bit error if the ECC feature is used.
   injectdbiterr_wdch => injectdbiterr_wdch, -- 1-bit input: Double Bit Error Injection- Injects a double bit error if the ECC feature is used.
   injectsbiterr_rdch => injectsbiterr_rdch, -- 1-bit input: Single Bit Error Injection- Injects a single bit error if the ECC feature is used.
   injectsbiterr_wdch => injectsbiterr_wdch, -- 1-bit input: Single Bit Error Injection- Injects a single bit error if the ECC feature is used.
   m_aclk => m_aclk,                         -- 1-bit input: Master Interface Clock: All signals on master interface are sampled on the rising
                                             -- edge of this clock.

   m_axi_arready => m_axi_arready,           -- 1-bit input: ARREADY: Indicates that the master can accept a transfer in the current cycle.
   m_axi_awready => m_axi_awready,           -- 1-bit input: AWREADY: Indicates that the master can accept a transfer in the current cycle.
   m_axi_bresp => m_axi_bresp,               -- 2-bit input: BRESP: Write Response. Indicates the status of the write transaction. The allowable
                                             -- responses are OKAY, EXOKAY, SLVERR, and DECERR.

   m_axi_bvalid => m_axi_bvalid,             -- 1-bit input: BVALID: Indicates that the master is driving a valid transfer. A transfer takes place
                                             -- when both BVALID and BREADY are asserted

   m_axi_rdata => m_axi_rdata,               -- AXI_DATA_WIDTH-bit input: RDATA: The primary payload that is used to provide the data that is
                                             -- passing across the interface. The width of the data payload is an integer number of bytes.

   m_axi_rresp => m_axi_rresp,               -- 2-bit input: RRESP: Indicates the status of the read transfer. The allowable responses are OKAY,
                                             -- EXOKAY, SLVERR, and DECERR.

   m_axi_rvalid => m_axi_rvalid,             -- 1-bit input: RVALID: Indicates that the master is driving a valid transfer. A transfer takes place
                                             -- when both RVALID and RREADY are asserted

   m_axi_wready => m_axi_wready,             -- 1-bit input: WREADY: Indicates that the master can accept a transfer in the current cycle.
   s_aclk => s_aclk,                         -- 1-bit input: Slave Interface Clock: All signals on slave interface are sampled on the rising edge
                                             -- of this clock.

   s_aresetn => s_aresetn,                   -- 1-bit input: Active low asynchronous reset.
   s_axi_araddr => s_axi_araddr,             -- AXI_ADDR_WIDTH-bit input: ARADDR: The read address bus gives the initial address of a read burst
                                             -- transaction. Only the start address of the burst is provided and the control signals that are
                                             -- issued alongside the address detail how the address is calculated for the remaining transfers in
                                             -- the burst.

   s_axi_arprot => s_axi_arprot,             -- 2-bit input: ARPROT: Indicates the normal, privileged, or secure protection level of the
                                             -- transaction and whether the transaction is a data access or an instruction access.

   s_axi_arvalid => s_axi_arvalid,           -- 1-bit input: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both ARVALID and ARREADY are asserted

   s_axi_awaddr => s_axi_awaddr,             -- AXI_ADDR_WIDTH-bit input: AWADDR: The write address bus gives the address of the first transfer in
                                             -- a write burst transaction. The associated control signals are used to determine the addresses of
                                             -- the remaining transfers in the burst.

   s_axi_awprot => s_axi_awprot,             -- 2-bit input: AWPROT: Indicates the normal, privileged, or secure protection level of the
                                             -- transaction and whether the transaction is a data access or an instruction access.

   s_axi_awvalid => s_axi_awvalid,           -- 1-bit input: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                             -- place when both AWVALID and AWREADY are asserted

   s_axi_bready => s_axi_bready,             -- 1-bit input: BREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_rready => s_axi_rready,             -- 1-bit input: RREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_wdata => s_axi_wdata,               -- AXI_DATA_WIDTH-bit input: WDATA: The primary payload that is used to provide the data that is
                                             -- passing across the interface. The width of the data payload is an integer number of bytes.

   s_axi_wstrb => s_axi_wstrb,               -- AXI_DATA_WIDTH/8-bit input: WSTRB: The byte qualifier that indicates whether the content of the
                                             -- associated byte of TDATA is processed as a data byte or a position byte. For a 64-bit DATA, bit 0
                                             -- corresponds to the least significant byte on DATA, and bit 0 corresponds to the least significant
                                             -- byte on DATA, and bit 7 corresponds to the most significant byte. For example: STROBE[0] = 1b,
                                             -- DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is not valid

   s_axi_wvalid => s_axi_wvalid              -- 1-bit input: WVALID: Indicates that the master is driving a valid transfer. A transfer takes place
                                             -- when both WVALID and WREADY are asserted

);

-- End of xpm_fifo_axil_inst instantiation
