-- xpm_nmu_mm: AXI Memory Mapped (AXI Full) NOC Master Unit
-- Xilinx Parameterized Macro, version 2025.2

xpm_nmu_mm_inst : xpm_nmu_mm
generic map (
   ADDR_WIDTH => 64,                -- DECIMAL
   AUSER_WIDTH => 16,               -- DECIMAL
   DATA_WIDTH => 512,               -- DECIMAL
   DUSER_WIDTH => 128,              -- DECIMAL
   ENABLE_FIREWALL => "false",      -- STRING
   ENABLE_USR_INTERRUPT => "false", -- STRING
   ID_WIDTH => 16,                  -- DECIMAL
   NOC_FABRIC => "VNOC",            -- STRING
   SIDEBAND_PINS => "false"         -- STRING
)
port map (
   nmu_firewall_rd_err => nmu_firewall_rd_err,   -- 1-bit output: Indicates that firewall error occured during read transaction
   nmu_firewall_wr_err => nmu_firewall_wr_err,   -- 1-bit output: Indicates that firewall error occured during write transaction
   s_axi_arready => s_axi_arready,               -- 1-bit output: ARREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_awready => s_axi_awready,               -- 1-bit output: AWREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_bid => s_axi_bid,                       -- ID_WIDTH-bit output: BID: The data stream identifier that indicates different streams of data.
   s_axi_bresp => s_axi_bresp,                   -- 2-bit output: BRESP: Indicates the status of the write transaction. The allowable responses
                                                 -- are OKAY, EXOKAY, SLVERR, and DECERR.

   s_axi_buser => s_axi_buser,                   -- 2-bit output: BUSER: Optional User-defined signal in the write response channel.
   s_axi_bvalid => s_axi_bvalid,                 -- 1-bit output: BVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                 -- place when both BVALID and BREADY are asserted

   s_axi_rdata => s_axi_rdata,                   -- DATA_WIDTH-bit output: RDATA: The primary payload that is used to provide the data that is
                                                 -- passing across the interface. The width of the data payload is an integer number of bytes.

   s_axi_rid => s_axi_rid,                       -- ID_WIDTH-bit output: RID: The data stream identifier that indicates different streams of data.
   s_axi_rlast => s_axi_rlast,                   -- 1-bit output: RLAST: Indicates the boundary of a packet.
   s_axi_rresp => s_axi_rresp,                   -- 2-bit output: RRESP: Indicates the status of the read transfer. The allowable responses are
                                                 -- OKAY, EXOKAY, SLVERR, and DECERR.

   s_axi_ruser => s_axi_ruser,                   -- DUSER_WIDTH-bit output: RUSER: User signal. Optional User-defined signal in the read data
                                                 -- channel.

   s_axi_rvalid => s_axi_rvalid,                 -- 1-bit output: RVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                 -- place when both RVALID and RREADY are asserted

   s_axi_wready => s_axi_wready,                 -- 1-bit output: WREADY: Indicates that the slave can accept a transfer in the current cycle.
   nmu_usr_interrupt_in => nmu_usr_interrupt_in, -- 4-bit input: User interrupt signal
   s_axi_aclk => s_axi_aclk,                     -- 1-bit input: Slave Interface Clock: All signals on slave interface are sampled on the rising
                                                 -- edge of this clock.

   s_axi_araddr => s_axi_araddr,                 -- ADDR_WIDTH-bit input: ARADDR: The read address bus gives the initial address of a read burst
                                                 -- transaction. Only the start address of the burst is provided and the control signals that are
                                                 -- issued alongside the address detail how the address is calculated for the remaining transfers
                                                 -- in the burst.

   s_axi_arburst => s_axi_arburst,               -- 2-bit input: ARBURST: The burst type, coupled with the size information, details how the
                                                 -- address for each transfer within the burst is calculated.

   s_axi_arcache => s_axi_arcache,               -- 4-bit input: ARCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                 -- allocate attributes of the transaction.

   s_axi_arid => s_axi_arid,                     -- ID_WIDTH-bit input: ARID: The data stream identifier that indicates different streams of data.
   s_axi_arlen => s_axi_arlen,                   -- 4-bit input: ARLEN: The burst length gives the exact number of transfers in a burst. This
                                                 -- information determines the number of data transfers associated with the address.

   s_axi_arlock => s_axi_arlock,                 -- 1-bit input: ARLOCK: This signal provides additional information about the atomic
                                                 -- characteristics of the transfer.

   s_axi_arprot => s_axi_arprot,                 -- 3-bit input: ARPROT: Indicates the normal, privileged, or secure protection level of the
                                                 -- transaction and whether the transaction is a data access or an instruction access.

   s_axi_arqos => s_axi_arqos,                   -- 4-bit input: ARQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                 -- transaction.

   s_axi_arregion => s_axi_arregion,             -- 4-bit input: ARREGION: Region identifier. Permits a single physical interface on a subordinate
                                                 -- to be used for multiple logical interfaces.

   s_axi_arsize => s_axi_arsize,                 -- 3-bit input: ARSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                 -- indicate exactly which byte lanes to update.

   s_axi_aruser => s_axi_aruser,                 -- AUSER_WIDTH-bit input: ARUSER: User signal. Optional User-defined signal in the read address
                                                 -- channel.

   s_axi_arvalid => s_axi_arvalid,               -- 1-bit input: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                 -- place when both ARVALID and ARREADY are asserted

   s_axi_awaddr => s_axi_awaddr,                 -- ADDR_WIDTH-bit input: AWADDR: The write address bus gives the address of the first transfer in
                                                 -- a write burst transaction. The associated control signals are used to determine the addresses
                                                 -- of the remaining transfers in the burst.

   s_axi_awburst => s_axi_awburst,               -- 2-bit input: AWBURST: The burst type, coupled with the size information, details how the
                                                 -- address for each transfer within the burst is calculated.

   s_axi_awcache => s_axi_awcache,               -- 4-bit input: AWCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                 -- allocate attributes of the transaction.

   s_axi_awid => s_axi_awid,                     -- ID_WIDTH-bit input: AWID: Identification tag for the write address group of signals.
   s_axi_awlen => s_axi_awlen,                   -- 8-bit input: AWLEN: The burst length gives the exact number of transfers in a burst. This
                                                 -- information determines the number of data transfers associated with the address.

   s_axi_awlock => s_axi_awlock,                 -- 1-bit input: AWLOCK: This signal provides additional information about the atomic
                                                 -- characteristics of the transfer.

   s_axi_awprot => s_axi_awprot,                 -- 3-bit input: AWPROT: Indicates the normal, privileged, or secure protection level of the
                                                 -- transaction and whether the transaction is a data access or an instruction access.

   s_axi_awqos => s_axi_awqos,                   -- 4-bit input: AWQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                 -- transaction.

   s_axi_awregion => s_axi_awregion,             -- 4-bit input: AWREGION: Permits a single physical interface on a subordinate to be used for
                                                 -- multiple logical interfaces.

   s_axi_awsize => s_axi_awsize,                 -- 3-bit input: AWSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                 -- indicate exactly which byte lanes to update.

   s_axi_awuser => s_axi_awuser,                 -- AUSER_WIDTH-bit input: AWUSER: Optional User-defined signal in the write address channel.
   s_axi_awvalid => s_axi_awvalid,               -- 1-bit input: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                 -- place when both AWVALID and AWREADY are asserted

   s_axi_bready => s_axi_bready,                 -- 1-bit input: BREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_rready => s_axi_rready,                 -- 1-bit input: RREADY: Indicates that the slave can accept a transfer in the current cycle.
   s_axi_wdata => s_axi_wdata,                   -- DATA_WIDTH-bit input: WDATA: The primary payload that is used to provide the data that is
                                                 -- passing across the interface. The width of the data payload is an integer number of bytes.

   s_axi_wid => s_axi_wid,                       -- ID_WIDTH-bit input: AWID: Write data channel command ID tag.
   s_axi_wlast => s_axi_wlast,                   -- 1-bit input: WLAST: Indicates the boundary of a packet.
   s_axi_wstrb => s_axi_wstrb,                   -- DATA_WIDTH/8-bit input: WSTRB: The byte qualifier that indicates whether the content of the
                                                 -- associated byte of TDATA is processed as a data byte or a position byte. For a 64-bit DATA,
                                                 -- bit 0 corresponds to the least significant byte on DATA, and bit 0 corresponds to the least
                                                 -- significant byte on DATA, and bit 7 corresponds to the most significant byte. For example:
                                                 -- STROBE[0] = 1b, DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is not valid

   s_axi_wuser => s_axi_wuser,                   -- DUSER_WIDTH-bit input: WUSER: Optional User-defined signal in the write data channel.
   s_axi_wvalid => s_axi_wvalid                  -- 1-bit input: WVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                 -- place when both WVALID and WREADY are asserted

);

-- End of xpm_nmu_mm_inst instantiation
