-- xpm_nmu_strm: AXI Streaming (AXI Full) NOC Master Unit
-- Xilinx Parameterized Macro, version 2025.2

xpm_nmu_strm_inst : xpm_nmu_strm
generic map (
   DATA_WIDTH => 512,    -- DECIMAL
   DST_ID_WIDTH => 4,    -- DECIMAL
   ID_WIDTH => 16,       -- DECIMAL
   NOC_FABRIC => "VNOC"  -- STRING
)
port map (
   dst_id_err => dst_id_err,       -- 1-bit output: Indicates DST ID error
   s_axis_tready => s_axis_tready, -- 1-bit output: TREADY: Indicates that the receiver can accept a transfer in the current cycle.
   s_axis_aclk => s_axis_aclk,     -- 1-bit input: Slave Interface Clock: All signals on slave interface are sampled on the rising edge of this
                                   -- clock.

   s_axis_tdata => s_axis_tdata,   -- DATA_WIDTH-bit input: TDATA: The primary payload that is used to provide the data that is passing across the
                                   -- interface. The width of the data payload is an integer number of bytes.

   s_axis_tdest => s_axis_tdest,   -- DST_ID_WIDTH-bit input: TDEST: Provides routing information for the data stream.
   s_axis_tid => s_axis_tid,       -- ID_WIDTH-bit input: TID: Identification tag for the data transfer
   s_axis_tkeep => s_axis_tkeep,   -- DATA_WIDTH/8-bit input: TKEEP: is the byte qualifier that indicates whether content of the associated byte
                                   -- of TDATA is processed as part of the data stream.

   s_axis_tlast => s_axis_tlast,   -- 1-bit input: TLAST: Indicates the boundary of a packet.
   s_axis_tvalid => s_axis_tvalid  -- 1-bit input: TVALID: indicates the Transmitter is driving a valid transfer. A transfer takes place when both
                                   -- TVALID and TREADY are asserted.

);

-- End of xpm_nmu_strm_inst instantiation
