-- xpm_nsu_strm: AXI Streaming (AXI Full) NOC Slave Unit
-- Xilinx Parameterized Macro, version 2025.2

xpm_nsu_strm_inst : xpm_nsu_strm
generic map (
   DATA_WIDTH => 512,    -- DECIMAL
   DST_ID_WIDTH => 4,    -- DECIMAL
   ID_WIDTH => 6,        -- DECIMAL
   NOC_FABRIC => "VNOC"  -- STRING
)
port map (
   m_axis_tdata => m_axis_tdata,   -- DATA_WIDTH-bit output: TDATA: The primary payload that is used to provide the data that is passing across
                                   -- the interface. The width of the data payload is an integer number of bytes.

   m_axis_tdest => m_axis_tdest,   -- DST_ID_WIDTH-bit output: TDEST: Provides routing information for the data stream.
   m_axis_tid => m_axis_tid,       -- ID_WIDTH-bit output: TID: Identification tag for the data transfer
   m_axis_tkeep => m_axis_tkeep,   -- DATA_WIDTH/8-bit output: TKEEP: is the byte qualifier that indicates whether content of the associated byte
                                   -- of TDATA is processed as part of the data stream.

   m_axis_tlast => m_axis_tlast,   -- 1-bit output: TLAST: Indicates the boundary of a packet.
   m_axis_tvalid => m_axis_tvalid, -- 1-bit output: TVALID: indicates the Transmitter is driving a valid transfer. A transfer takes place when
                                   -- both TVALID and TREADY are asserted.

   m_axis_aclk => m_axis_aclk,     -- 1-bit input: Master Interface Clock: All signals on slave interface are sampled on the rising edge of this
                                   -- clock.

   m_axis_tready => m_axis_tready  -- 1-bit input: TREADY: Indicates that the receiver can accept a transfer in the current cycle.
);

-- End of xpm_nsu_strm_inst instantiation
