-- xpm_pmc_bridge: AXI Memory Mapped (AXI Full) PMC BRIDGE
-- Xilinx Parameterized Macro, version 2025.2

xpm_pmc_bridge_inst : xpm_pmc_bridge
generic map (
   ADDR_WIDTH => 28, -- DECIMAL
   DATA_WIDTH => 32, -- DECIMAL
   ID_WIDTH => 1     -- DECIMAL
)
port map (
   S_AXI_arready => S_AXI_arready, -- 1-bit output: ARREADY: Indicates that the slave can accept a transfer in the current cycle.
   S_AXI_awready => S_AXI_awready, -- 1-bit output: AWREADY: Indicates that the slave can accept a transfer in the current cycle.
   S_AXI_bid => S_AXI_bid,         -- ID_WIDTH-bit output: BID: The data stream identifier that indicates different streams of data.
   S_AXI_bresp => S_AXI_bresp,     -- 2-bit output: BRESP: Indicates the status of the write transaction. The allowable responses are OKAY,
                                   -- EXOKAY, SLVERR, and DECERR.

   S_AXI_bvalid => S_AXI_bvalid,   -- 1-bit output: BVALID: Indicates that the master is driving a valid transfer. A transfer takes place when
                                   -- both BVALID and BREADY are asserted

   S_AXI_rdata => S_AXI_rdata,     -- DATA_WIDTH-bit output: RDATA: The primary payload that is used to provide the data that is passing across
                                   -- the interface. The width of the data payload is an integer number of bytes.

   S_AXI_rid => S_AXI_rid,         -- ID_WIDTH-bit output: RID: The data stream identifier that indicates different streams of data.
   S_AXI_rlast => S_AXI_rlast,     -- 1-bit output: RLAST: Indicates the boundary of a packet.
   S_AXI_rresp => S_AXI_rresp,     -- 2-bit output: RRESP: Indicates the status of the read transfer. The allowable responses are OKAY, EXOKAY,
                                   -- SLVERR, and DECERR.

   S_AXI_rvalid => S_AXI_rvalid,   -- 1-bit output: RVALID: Indicates that the master is driving a valid transfer. A transfer takes place when
                                   -- both RVALID and RREADY are asserted

   S_AXI_wready => S_AXI_wready,   -- 1-bit output: WREADY: Indicates that the slave can accept a transfer in the current cycle.
   S_AXI_araddr => S_AXI_araddr,   -- ADDR_WIDTH-bit input: ARADDR: The read address bus gives the initial address of a read burst transaction.
                                   -- Only the start address of the burst is provided and the control signals that are issued alongside the
                                   -- address detail how the address is calculated for the remaining transfers in the burst.

   S_AXI_arburst => S_AXI_arburst, -- 2-bit input: ARBURST: The burst type, coupled with the size information, details how the address for each
                                   -- transfer within the burst is calculated.

   S_AXI_arcache => S_AXI_arcache, -- 4-bit input: ARCACHE: Indicates the bufferable, cacheable, write-through, write-back, and allocate
                                   -- attributes of the transaction.

   S_AXI_arid => S_AXI_arid,       -- ID_WIDTH-bit input: ARID: The data stream identifier that indicates different streams of data.
   S_AXI_arlen => S_AXI_arlen,     -- 8-bit input: ARLEN: The burst length gives the exact number of transfers in a burst. This information
                                   -- determines the number of data transfers associated with the address.

   S_AXI_arlock => S_AXI_arlock,   -- 1-bit input: ARLOCK: This signal provides additional information about the atomic characteristics of the
                                   -- transfer.

   S_AXI_arprot => S_AXI_arprot,   -- 3-bit input: ARPROT: Indicates the normal, privileged, or secure protection level of the transaction and
                                   -- whether the transaction is a data access or an instruction access.

   S_AXI_arqos => S_AXI_arqos,     -- 4-bit input: ARQOS: Quality of Service (QoS) sent on the write address channel for each write transaction.
   S_AXI_arsize => S_AXI_arsize,   -- 3-bit input: ARSIZE: Indicates the size of each transfer in the burst. Byte lane strobes indicate exactly
                                   -- which byte lanes to update.

   S_AXI_arvalid => S_AXI_arvalid, -- 1-bit input: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes place when
                                   -- both ARVALID and ARREADY are asserted

   S_AXI_awaddr => S_AXI_awaddr,   -- ADDR_WIDTH-bit input: AWADDR: The write address bus gives the address of the first transfer in a write burst
                                   -- transaction. The associated control signals are used to determine the addresses of the remaining transfers
                                   -- in the burst.

   S_AXI_awburst => S_AXI_awburst, -- 2-bit input: AWBURST: The burst type, coupled with the size information, details how the address for each
                                   -- transfer within the burst is calculated.

   S_AXI_awcache => S_AXI_awcache, -- 4-bit input: AWCACHE: Indicates the bufferable, cacheable, write-through, write-back, and allocate
                                   -- attributes of the transaction.

   S_AXI_awid => S_AXI_awid,       -- ID_WIDTH-bit input: AWID: Identification tag for the write address group of signals.
   S_AXI_awlen => S_AXI_awlen,     -- 8-bit input: AWLEN: The burst length gives the exact number of transfers in a burst. This information
                                   -- determines the number of data transfers associated with the address.

   S_AXI_awlock => S_AXI_awlock,   -- 1-bit input: AWLOCK: This signal provides additional information about the atomic characteristics of the
                                   -- transfer.

   S_AXI_awprot => S_AXI_awprot,   -- 3-bit input: AWPROT: Indicates the normal, privileged, or secure protection level of the transaction and
                                   -- whether the transaction is a data access or an instruction access.

   S_AXI_awqos => S_AXI_awqos,     -- 4-bit input: AWQOS: Quality of Service (QoS) sent on the write address channel for each write transaction.
   S_AXI_awsize => S_AXI_awsize,   -- 3-bit input: AWSIZE: Indicates the size of each transfer in the burst. Byte lane strobes indicate exactly
                                   -- which byte lanes to update.

   S_AXI_awvalid => S_AXI_awvalid, -- 1-bit input: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes place when
                                   -- both AWVALID and AWREADY are asserted

   S_AXI_bready => S_AXI_bready,   -- 1-bit input: BREADY: Indicates that the slave can accept a transfer in the current cycle.
   S_AXI_clk => S_AXI_clk,         -- 1-bit input: Slave Interface Clock: All signals on slave interface are sampled on the rising edge of this
                                   -- clock.

   S_AXI_rready => S_AXI_rready,   -- 1-bit input: RREADY: Indicates that the slave can accept a transfer in the current cycle.
   S_AXI_wdata => S_AXI_wdata,     -- DATA_WIDTH-bit input: WDATA: The primary payload that is used to provide the data that is passing across the
                                   -- interface. The width of the data payload is an integer number of bytes.

   S_AXI_wlast => S_AXI_wlast,     -- 1-bit input: WLAST: Indicates the boundary of a packet.
   S_AXI_wstrb => S_AXI_wstrb,     -- DATA_WIDTH/8-bit input: WSTRB: The byte qualifier that indicates whether the content of the associated byte
                                   -- of TDATA is processed as a data byte or a position byte. For a 64-bit DATA, bit 0 corresponds to the least
                                   -- significant byte on DATA, and bit 0 corresponds to the least significant byte on DATA, and bit 7 corresponds
                                   -- to the most significant byte. For example: STROBE[0] = 1b, DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is
                                   -- not valid

   S_AXI_wvalid => S_AXI_wvalid    -- 1-bit input: WVALID: Indicates that the master is driving a valid transfer. A transfer takes place when both
                                   -- WVALID and WREADY are asserted

);

-- End of xpm_pmc_bridge_inst instantiation
