// xpm_cdc_gray: Synchronizer via Gray Encoding
// Xilinx Parameterized Macro, version 2025.2

xpm_cdc_gray #(
   .DEST_SYNC_FF(4),          // DECIMAL; range: 2-10
   .INIT_SYNC_FF(0),          // DECIMAL; 0=disable simulation init values, 1=enable simulation init values
   .REG_OUTPUT(0),            // DECIMAL; 0=disable registered output, 1=enable registered output
   .SIM_ASSERT_CHK(0),        // DECIMAL; 0=disable simulation messages, 1=enable simulation messages
   .SIM_LOSSLESS_GRAY_CHK(0), // DECIMAL; 0=disable lossless check, 1=enable lossless check
   .WIDTH(2)                  // DECIMAL; range: 2-32
)
xpm_cdc_gray_inst (
   .dest_out_bin(dest_out_bin), // WIDTH-bit output: Binary input bus (src_in_bin) synchronized to destination clock domain. This output is
                                // combinatorial unless REG_OUTPUT is set to 1.

   .dest_clk(dest_clk),         // 1-bit input: Destination clock.
   .src_clk(src_clk),           // 1-bit input: Source clock.
   .src_in_bin(src_in_bin)      // WIDTH-bit input: Binary input bus that will be synchronized to the destination clock domain.
);

// End of xpm_cdc_gray_inst instantiation
