// xpm_memory_dprom: Dual Port ROM
// Xilinx Parameterized Macro, version 2025.2

xpm_memory_dprom #(
   .ADDR_WIDTH_A(6),               // DECIMAL
   .ADDR_WIDTH_B(6),               // DECIMAL
   .AUTO_SLEEP_TIME(0),            // DECIMAL
   .CASCADE_HEIGHT(0),             // DECIMAL
   .CLOCKING_MODE("common_clock"), // String
   .ECC_BIT_RANGE("7:0"),          // String
   .ECC_MODE("no_ecc"),            // String
   .ECC_TYPE("none"),              // String
   .IGNORE_INIT_SYNTH(0),          // DECIMAL
   .MEMORY_INIT_FILE("none"),      // String
   .MEMORY_INIT_PARAM("0"),        // String
   .MEMORY_OPTIMIZATION("true"),   // String
   .MEMORY_PRIMITIVE("auto"),      // String
   .MEMORY_SIZE(2048),             // DECIMAL
   .MESSAGE_CONTROL(0),            // DECIMAL
   .RAM_DECOMP("auto"),            // String
   .READ_DATA_WIDTH_A(32),         // DECIMAL
   .READ_DATA_WIDTH_B(32),         // DECIMAL
   .READ_LATENCY_A(2),             // DECIMAL
   .READ_LATENCY_B(2),             // DECIMAL
   .READ_RESET_VALUE_A("0"),       // String
   .READ_RESET_VALUE_B("0"),       // String
   .RST_MODE_A("SYNC"),            // String
   .RST_MODE_B("SYNC"),            // String
   .SIM_ASSERT_CHK(0),             // DECIMAL; 0=disable simulation messages, 1=enable simulation messages
   .USE_MEM_INIT(1),               // DECIMAL
   .USE_MEM_INIT_MMI(0),           // DECIMAL
   .WAKEUP_TIME("disable_sleep")   // String
)
xpm_memory_dprom_inst (
   .dbiterra(dbiterra),             // 1-bit output: Leave open.
   .dbiterrb(dbiterrb),             // 1-bit output: Leave open.
   .douta(douta),                   // READ_DATA_WIDTH_A-bit output: Data output for port A read operations.
   .doutb(doutb),                   // READ_DATA_WIDTH_B-bit output: Data output for port B read operations.
   .sbiterra(sbiterra),             // 1-bit output: Leave open.
   .sbiterrb(sbiterrb),             // 1-bit output: Leave open.
   .addra(addra),                   // ADDR_WIDTH_A-bit input: Address for port A read operations.
   .addrb(addrb),                   // ADDR_WIDTH_B-bit input: Address for port B read operations.
   .clka(clka),                     // 1-bit input: Clock signal for port A. Also clocks port B when parameter CLOCKING_MODE is "common_clock".
   .clkb(clkb),                     // 1-bit input: Clock signal for port B when parameter CLOCKING_MODE is "independent_clock". Unused when
                                    // parameter CLOCKING_MODE is "common_clock".

   .ena(ena),                       // 1-bit input: Memory enable signal for port A. Must be high on clock cycles when read operations are
                                    // initiated. Pipelined internally.

   .enb(enb),                       // 1-bit input: Memory enable signal for port B. Must be high on clock cycles when read operations are
                                    // initiated. Pipelined internally.

   .injectdbiterra(injectdbiterra), // 1-bit input: Do not change from the provided value.
   .injectdbiterrb(injectdbiterrb), // 1-bit input: Do not change from the provided value.
   .injectsbiterra(injectsbiterra), // 1-bit input: Do not change from the provided value.
   .injectsbiterrb(injectsbiterrb), // 1-bit input: Do not change from the provided value.
   .regcea(regcea),                 // 1-bit input: Do not change from the provided value.
   .regceb(regceb),                 // 1-bit input: Do not change from the provided value.
   .rsta(rsta),                     // 1-bit input: Reset signal for the final port A output register stage. Synchronously resets output port
                                    // douta to the value specified by parameter READ_RESET_VALUE_A.

   .rstb(rstb),                     // 1-bit input: Reset signal for the final port B output register stage. Synchronously resets output port
                                    // doutb to the value specified by parameter READ_RESET_VALUE_B.

   .sleep(sleep)                    // 1-bit input: sleep signal to enable the dynamic power saving feature.
);

// End of xpm_memory_dprom_inst instantiation
