// xpm_nsu_mm: AXI Memory Mapped (AXI Full) NOC Slave Unit
// Xilinx Parameterized Macro, version 2025.2

xpm_nsu_mm #(
   .ADDR_WIDTH(64),                // DECIMAL
   .AUSER_WIDTH(16),               // DECIMAL
   .DATA_WIDTH(512),               // DECIMAL
   .DUSER_WIDTH(128),              // DECIMAL
   .ENABLE_FIREWALL("false"),      // STRING
   .ENABLE_USR_INTERRUPT("false"), // STRING
   .ID_WIDTH(2),                   // DECIMAL
   .NOC_FABRIC("VNOC"),            // STRING
   .SIDEBAND_PINS("false")         // STRING
)
xpm_nsu_mm_inst (
   .m_axi_araddr(m_axi_araddr),                 // ADDR_WIDTH-bit output: ARADDR: The read address bus gives the initial address of a read burst
                                                // transaction. Only the start address of the burst is provided and the control signals that are
                                                // issued alongside the address detail how the address is calculated for the remaining transfers
                                                // in the burst.

   .m_axi_arburst(m_axi_arburst),               // 2-bit output: ARBURST: The burst type, coupled with the size information, details how the
                                                // address for each transfer within the burst is calculated.

   .m_axi_arcache(m_axi_arcache),               // 4-bit output: ARCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                // allocate attributes of the transaction.

   .m_axi_arid(m_axi_arid),                     // ID_WIDTH-bit output: ARID: The data stream identifier that indicates different streams of data.
   .m_axi_arlen(m_axi_arlen),                   // 4-bit output: ARLEN: The burst length gives the exact number of transfers in a burst. This
                                                // information determines the number of data transfers associated with the address.

   .m_axi_arlock(m_axi_arlock),                 // 1-bit output: ARLOCK: This signal provides additional information about the atomic
                                                // characteristics of the transfer.

   .m_axi_arprot(m_axi_arprot),                 // 3-bit output: ARPROT: Indicates the normal, privileged, or secure protection level of the
                                                // transaction and whether the transaction is a data access or an instruction access.

   .m_axi_arqos(m_axi_arqos),                   // 4-bit output: ARQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                // transaction.

   .m_axi_arregion(m_axi_arregion),             // 4-bit output: ARREGION: Region identifier. Permits a single physical interface on a subordinate
                                                // to be used for multiple logical interfaces.

   .m_axi_arsize(m_axi_arsize),                 // 3-bit output: ARSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                // indicate exactly which byte lanes to update.

   .m_axi_aruser(m_axi_aruser),                 // AUSER_WIDTH-bit output: ARUSER: User signal. Optional User-defined signal in the read address
                                                // channel.

   .m_axi_arvalid(m_axi_arvalid),               // 1-bit output: ARVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                // place when both ARVALID and ARREADY are asserted

   .m_axi_awaddr(m_axi_awaddr),                 // ADDR_WIDTH-bit output: AWADDR: The write address bus gives the address of the first transfer in
                                                // a write burst transaction. The associated control signals are used to determine the addresses
                                                // of the remaining transfers in the burst.

   .m_axi_awburst(m_axi_awburst),               // 2-bit output: AWBURST: The burst type, coupled with the size information, details how the
                                                // address for each transfer within the burst is calculated.

   .m_axi_awcache(m_axi_awcache),               // 4-bit output: AWCACHE: Indicates the bufferable, cacheable, write-through, write-back, and
                                                // allocate attributes of the transaction.

   .m_axi_awid(m_axi_awid),                     // ID_WIDTH-bit output: AWID: Identification tag for the write address group of signals.
   .m_axi_awlen(m_axi_awlen),                   // 8-bit output: AWLEN: The burst length gives the exact number of transfers in a burst. This
                                                // information determines the number of data transfers associated with the address.

   .m_axi_awlock(m_axi_awlock),                 // 1-bit output: AWLOCK: This signal provides additional information about the atomic
                                                // characteristics of the transfer.

   .m_axi_awprot(m_axi_awprot),                 // 3-bit output: AWPROT: Indicates the normal, privileged, or secure protection level of the
                                                // transaction and whether the transaction is a data access or an instruction access.

   .m_axi_awqos(m_axi_awqos),                   // 4-bit output: AWQOS: Quality of Service (QoS) sent on the write address channel for each write
                                                // transaction.

   .m_axi_awregion(m_axi_awregion),             // 4-bit output: AWREGION: Permits a single physical interface on a subordinate to be used for
                                                // multiple logical interfaces.

   .m_axi_awsize(m_axi_awsize),                 // 3-bit output: AWSIZE: Indicates the size of each transfer in the burst. Byte lane strobes
                                                // indicate exactly which byte lanes to update.

   .m_axi_awuser(m_axi_awuser),                 // AUSER_WIDTH-bit output: AWUSER: Optional User-defined signal in the write address channel.
   .m_axi_awvalid(m_axi_awvalid),               // 1-bit output: AWVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                // place when both AWVALID and AWREADY are asserted

   .m_axi_bready(m_axi_bready),                 // 1-bit output: BREADY: Indicates that the slave can accept a transfer in the current cycle.
   .m_axi_out(m_axi_out),                       // 1-bit output: AXI ouput signal
   .m_axi_rready(m_axi_rready),                 // 1-bit output: RREADY: Indicates that the slave can accept a transfer in the current cycle.
   .m_axi_wdata(m_axi_wdata),                   // DATA_WIDTH-bit output: WDATA: The primary payload that is used to provide the data that is
                                                // passing across the interface. The width of the data payload is an integer number of bytes.

   .m_axi_wlast(m_axi_wlast),                   // 1-bit output: WLAST: Indicates the boundary of a packet.
   .m_axi_wstrb(m_axi_wstrb),                   // DATA_WIDTH/8-bit output: WSTRB: The byte qualifier that indicates whether the content of the
                                                // associated byte of TDATA is processed as a data byte or a position byte. For a 64-bit DATA, bit
                                                // 0 corresponds to the least significant byte on DATA, and bit 0 corresponds to the least
                                                // significant byte on DATA, and bit 7 corresponds to the most significant byte. For example:
                                                // STROBE[0] = 1b, DATA[7:0] is valid STROBE[7] = 0b, DATA[63:56] is not valid

   .m_axi_wuser(m_axi_wuser),                   // DUSER_WIDTH-bit output: WUSER: User signal. Optional User-defined signal in the write data
                                                // channel.

   .m_axi_wvalid(m_axi_wvalid),                 // 1-bit output: WVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                // place when both WVALID and WREADY are asserted

   .nsu_firewall_err(nsu_firewall_err),         // 1-bit output: Indicates that firewall error occured during write or read transaction
   .m_axi_aclk(m_axi_aclk),                     // 1-bit input: Master Interface Clock: All signals on slave interface are sampled on the rising
                                                // edge of this clock.

   .m_axi_arready(m_axi_arready),               // 1-bit input: ARREADY: Indicates that the slave can accept a transfer in the current cycle.
   .m_axi_awready(m_axi_awready),               // 1-bit input: AWREADY: Indicates that the slave can accept a transfer in the current cycle.
   .m_axi_bid(m_axi_bid),                       // ID_WIDTH-bit input: BID: The data stream identifier that indicates different streams of data.
   .m_axi_bresp(m_axi_bresp),                   // 2-bit input: BRESP: Indicates the status of the write transaction. The allowable responses are
                                                // OKAY, EXOKAY, SLVERR, and DECERR.

   .m_axi_buser(m_axi_buser),                   // 2-bit input: BUSER: Optional User-defined signal in the write response channel.
   .m_axi_bvalid(m_axi_bvalid),                 // 1-bit input: BVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                // place when both BVALID and BREADY are asserted

   .m_axi_rdata(m_axi_rdata),                   // DATA_WIDTH-bit input: RDATA: The primary payload that is used to provide the data that is
                                                // passing across the interface. The width of the data payload is an integer number of bytes.

   .m_axi_rid(m_axi_rid),                       // ID_WIDTH-bit input: RID: The data stream identifier that indicates different streams of data.
   .m_axi_rlast(m_axi_rlast),                   // 1-bit input: RLAST: Indicates the boundary of a packet.
   .m_axi_rresp(m_axi_rresp),                   // 2-bit input: RRESP: Indicates the status of the read transfer. The allowable responses are
                                                // OKAY, EXOKAY, SLVERR, and DECERR.

   .m_axi_ruser(m_axi_ruser),                   // DUSER_WIDTH-bit input: RUSER: User signal. Optional User-defined signal in the read data
                                                // channel.

   .m_axi_rvalid(m_axi_rvalid),                 // 1-bit input: RVALID: Indicates that the master is driving a valid transfer. A transfer takes
                                                // place when both RVALID and RREADY are asserted

   .m_axi_wready(m_axi_wready),                 // 1-bit input: WREADY: Indicates that the slave can accept a transfer in the current cycle.
   .nsu_usr_interrupt_in(nsu_usr_interrupt_in)  // 4-bit input: User interrupt signal
);

// End of xpm_nsu_mm_inst instantiation
