import os
import shutil
import sys

# Constants
BASE_SRC_ROOT = r"C:\Users\Administrator\Desktop\golden_folder"
script_dir = os.path.dirname(os.path.abspath(__file__))
os.chdir(script_dir)
DES_ROOT = os.getcwd()
FILES_TO_COPY = ["ifm.bin", "ofm.bin"]

def copy_selected_files(src_root, des_root, files_to_copy, mode="copy"):
    # In this version, src_root is where files are copied TO (destination in update mode)
    # des_root is where files are copied FROM (source in update mode)

    for subdir in os.listdir(des_root):
        des_subdir = os.path.join(des_root, subdir)
        src_subdir = os.path.join(src_root, subdir)

        if os.path.isdir(des_subdir):
            os.makedirs(src_subdir, exist_ok=True)

            for filename in files_to_copy:
                des_file = os.path.join(des_subdir, filename)
                src_file = os.path.join(src_subdir, filename)

                if mode == "copy":
                    if os.path.exists(src_file):
                        shutil.copy2(src_file, des_file)
                        print(f"[COPY] {src_file} -> {des_file}")
                    else:
                        print(f"[SKIP] File not found: {src_file}")

                elif mode == "update":
                    if os.path.exists(des_file):
                        shutil.copy2(des_file, src_file)
                        print(f"[UPDATE] {des_file} -> {src_file}")
                    else:
                        print(f"[SKIP] File not found for update: {des_file}")

                else:
                    print(f"[ERROR] Unknown mode: {mode}")
                    return

if __name__ == "__main__":
    subfolder = sys.argv[1] if len(sys.argv) > 1 and sys.argv[1] != "update" else ""
    mode = "update" if "update" in sys.argv else "copy"

    # If running as `python copy_golden_io.py update`, subfolder will be ""
    subfolders = (
        [subfolder] if subfolder else
        [d for d in os.listdir(BASE_SRC_ROOT) if os.path.isdir(os.path.join(BASE_SRC_ROOT, d))])

    SRC_ROOT = BASE_SRC_ROOT

    for sf in subfolders:
        src_path = os.path.join(SRC_ROOT, sf)

    #  Ensure the subfolder exists in update mode
    if mode == "update":
        os.makedirs(src_path, exist_ok=True)

    copy_selected_files(src_path, DES_ROOT, FILES_TO_COPY, mode)
