import os
import json
import time
import fnmatch

# Function to extract required information from JSON content
def extract_info(json_content):
    op_type = json_content["layer_info"]["op_type"]
    in_shapes = []
    out_shapes = []
    
    for key, val in json_content["layer_info"].items():
        if fnmatch.fnmatch(key, 'in_*_shape'):
            in_shapes.append("x".join(map(str, val)))
        if fnmatch.fnmatch(key, 'out_*_shape'):
            out_shapes.append("x".join(map(str, val)))

    in_shapes_str = "_".join(in_shapes)
    out_shapes_str = "_".join(out_shapes)

    return f"{op_type}_{in_shapes_str}_{out_shapes_str}"

# Main directory path
main_dir = "."

# Iterate over each folder in the main directory
for folder_name in os.listdir(main_dir):
    folder_path = os.path.join(main_dir, folder_name)
    
    # Check if it is a directory
    if os.path.isdir(folder_path):
        json_file_path = os.path.join(folder_path, f"{folder_name}.json")
        
        # Check if the JSON file exists
        if os.path.exists(json_file_path):
            with open(json_file_path, 'r') as json_file:
                json_content = json.load(json_file)
                
            # Ensure the file is closed before proceeding
            time.sleep(1)
            
            # Extract information and create new folder name
            try:
                new_folder_name = extract_info(json_content)
                new_folder_path = os.path.join(main_dir, new_folder_name)
                
                # Rename the folder
                os.rename(folder_path, new_folder_path)
                print(f"Renamed '{folder_name}' to '{new_folder_name}'")
            except ValueError as e:
                print(f"Failed to rename '{folder_name}': {e}")
