#analyze all tilings
import json

filename = "all_tiling.json"
with open(filename, 'r') as file:
    data = json.load(file)

sample_config = data[list(data.keys())[0]]

optype = sample_config['layer_info']['op_type']
shape  = sample_config['layer_info']['in_ifm_shape'] + sample_config['layer_info']['in_wgt_shape'][-1:]
print(f"optype: {optype}")
print(f"shape: {shape}")

for key, cfg in data.items():
    subv   = cfg['core_tile_params']['subvols']['ifm'][1:] + cfg['core_tile_params']['subvols']['wgt'][-1:]
    ss     = cfg['overlay_info']['mode']
    kernel_info = cfg['kernel_info']
    ifm_mode = cfg['scheduling']['ifm']
    wgt_mode = cfg['scheduling']['wgt']
    pad_m = cfg['dma_layer_padding'][0]['ifm']['dims'][1]
    pad_k = cfg['dma_layer_padding'][0]['ifm']['dims'][2]
    pad_n = cfg['dma_layer_padding'][2]['ofm']['dims'][2]
    Tm = cfg['core_tile_params']['iters']['ifm'][1] * cfg['mem_tile_params']['iters']['ifm'][1]
    Tk = cfg['core_tile_params']['iters']['wgt'][1] * cfg['mem_tile_params']['iters']['wgt'][1]
    Tn = cfg['core_tile_params']['iters']['wgt'][2] * cfg['mem_tile_params']['iters']['wgt'][2]
    #if subv[0]==64 and subv[2]==64:
    if (pad_m == 0 or Tm==1) and pad_k==0 and Tm*Tk*Tn<=512:#(ss == "M32K1N1" or ss == "M8K1N4") and  and (pad_n==0 or Tn==1):
        print(f"{key}: spatial_split: {ss}, subv: {subv}, ifm_mode: {ifm_mode}, wgt_mode: {wgt_mode}, pad_k: {pad_k}, pad_n: {pad_n}, Tm:{Tm}, Tk:{Tk}, Tn:{Tn}, Tm*Tk*Tn: {Tm*Tk*Tn}")#
