import os
import sys
import json
import traceback
import subprocess
import random
import shutil
import numpy as np

REPO_ROOT = os.path.abspath(os.path.join(os.path.dirname(__file__),"../../"))

def extract_fields(file_name):
    if os.path.exists(file_name):
        with open(file_name, "r") as f:
            data = json.load(f)
        return data
    else:
        return None

def check_padding():
    test_dir = os.path.join(REPO_ROOT, "WAIC_Outputs")
    df_dir = [ft.name for ft in os.scandir(test_dir) if ft.is_dir()]
    Kpad = {}
    for op in df_dir:
        op_json_path = os.path.join(test_dir, str(op), f"{op}.json")
        data = extract_fields(op_json_path)
        Kpad[op] =data['layer_info']['in_wgt_shape'][1] - data['layer_info']['in_wgt1_shape'][0]
        if Kpad[op] > 0:
            print(f"N Padding for {op} is {Kpad[op]}")
        
if __name__ == "__main__":
    check_padding()