import sys
sys.path.append('.')
sys.path.append('..')
sys.path.append('../..')

import subprocess
from typing import List

from dmacompiler import BackEnd
#from gemm_m4_n4X_dataflow import generate_a16w8_gemm_qdq
import data_flow
#import overlay_actxwgt_act_pin_gemm_M4_N4_split 

def aiecompiler_args(
    M: int, K: int, N: int,
    M_subv: int, K_subv: int, N_subv: int,
    back_end: BackEnd
) -> List[str]:
    host_filename = 'main_gemm_K.cpp' if back_end == BackEnd.Adf else 'txn_gemm_K.cpp'
    return [
        'aiecompiler',
        host_filename,
        '--target=hw',
        '--part=xc10AIE2P_ML-die-0x-e-S-es1',
        '--adf-api-log-level=3',
        '--stacksize=4480',
        '--heapsize=2048',
        '--enable-core-processor-bus=true',
        '--disable-dma-autostart=true',
        '--large-program-memory=true',
        '--include=../../kernels/',
        '--include=../../kernels/common/',
        '--include=../../kernels/include/',
        f'--Xpreproc="-DM_GEMM_A16W8={M}"',
        f'--Xpreproc="-DK_GEMM_A16W8={K}"',
        f'--Xpreproc="-DN_GEMM_A16W8={N}"',
        f'--Xpreproc="-DM_GEMM_SUBV_A16W8={M_subv}"',
        f'--Xpreproc="-DK_GEMM_SUBV_A16W8={K_subv}"',
        f'--Xpreproc="-DN_GEMM_SUBV_A16W8={N_subv}"',
        '--Xpreproc="-DLOG_CORE_COL=0"',
        '--Xpreproc="-DLOG_CORE_ROW=2"',
    ]


def main():
    assert len(sys.argv) in (1, 2)
    shape_index = int(sys.argv[1]) if len(sys.argv) == 2 else None
    back_end = BackEnd.Txn
    shape_table = [
        ((4096, 320, 320), (32, 80, 80)),
        ((4096, 640, 320), (32, 80, 80)),
        ((4096, 960, 320), (32, 80, 80)),
        ((4096, 1280, 320), (32, 80, 80)),
        ((4096, 320, 2560), (32, 80, 80)),
        ((1024, 640, 640), (32, 80, 80)),
        ((1024, 960, 640), (32, 80, 80)),
        ((1024, 1280, 640), (32, 80, 80)),
        ((1024, 1920, 640), (32, 80, 80)),
        ((1024, 2560, 640), (16, 160, 32)),
        ((256, 640, 1280), (32, 128, 64)),  #10
        ((256, 1280, 1280), (32, 160, 32)), #11
        ((256, 1280, 2560), (32, 160, 32)), #12
        ((256, 2560, 256), (32, 80, 64)),   #13
        ((255, 640, 1280), (32, 128, 64)),  #14
        ((4095, 640, 1280), (32, 128, 64)),  #15
        ((4063, 640, 1280), (32, 128, 64)),  #16
        ((256, 520, 1280), (32, 128, 64)),  #17
    ]
    if shape_index is not None:
        shape_table = [shape_table[shape_index]]
    #if back_end == BackEnd.Txn:
    #    subprocess.run('rm -rf shapes', shell=True)
    for (M, K, N), (M_subv, K_subv, N_subv) in shape_table:
        compile_args = aiecompiler_args(M, K, N, M_subv, K_subv, N_subv, back_end)
        subprocess.run('make clean', shell=True)
        #generate_a16w8_gemm_qdq(M, K, N, M_subv, K_subv, N_subv, back_end)
        data_flow.main(back_end)
        #overlay_actxwgt_act_pin_gemm_M4_N4_split.generate_a16w8_gemm_qdq(M, K, N, M_subv, K_subv, N_subv, back_end)
        subprocess.run(compile_args)
        subprocess.run(
            "sed -i 's/-ladf_api/-ladf_rt_ctrl_api -ladf_api/g' Work/ps/c_rts/systemC/Makefile",
            shell=True
        )
        subprocess.run(
            'make -C Work/ps/c_rts/systemC/ all',
            shell=True
        )
        subprocess.run(['aiesimulator', '--profile'])
        if back_end == BackEnd.Txn:
            out_folder = f'shapes/gemm_a16w8_{M}_{K}_{N}_{M_subv}_{K_subv}_{N_subv}'
            subprocess.run(f'mkdir -p {out_folder}', shell=True)
            subprocess.run(f'cp *.bin {out_folder}', shell=True)


if __name__ == '__main__':
    main()
