import sys
import os
import glob
import json
import shutil
import importlib
sys.path.append('.')
sys.path.append('..')
sys.path.append('../..')

import subprocess
from typing import List

from dmacompiler import BackEnd
#from gemm_m4_n4X_dataflow import generate_a16w8_gemm_qdq
#import data_flow
#import overlay_actxwgt_act_pin_gemm_M4_N4_split 

def aiecompiler_args(
    M: int, K: int, N: int,
    M_subv: int, K_subv: int, N_subv: int,
    back_end: BackEnd
) -> List[str]:
    host_filename = 'main_gemm.cpp' if back_end == BackEnd.Adf else 'txn_gemm.cpp'
    return [
        'aiecompiler',
        host_filename,
        '--target=hw',
        '--part=xc10AIE2P_ML-die-0x-e-S-es1',
        '--adf-api-log-level=3',
        '--stacksize=4480',
        '--heapsize=2048',
        '--enable-core-processor-bus=true',
        '--disable-dma-autostart=true',
        '--large-program-memory=true',
        '--include=../../kernels/',
        '--include=../../kernels/common/',
        '--include=../../kernels/include/',
        f'--Xpreproc="-DM_GEMM_A16W8={M}"',
        f'--Xpreproc="-DK_GEMM_A16W8={K}"',
        f'--Xpreproc="-DN_GEMM_A16W8={N}"',
        f'--Xpreproc="-DM_GEMM_SUBV_A16W8={M_subv}"',
        f'--Xpreproc="-DK_GEMM_SUBV_A16W8={K_subv}"',
        f'--Xpreproc="-DN_GEMM_SUBV_A16W8={N_subv}"',
        '--Xpreproc="-DLOG_CORE_COL=0"',
        '--Xpreproc="-DLOG_CORE_ROW=2"',
    ]

def search_json_files(mp, dfpath):
    shape_list = []
    for dir_path in dfpath:
        filename = glob.glob(mp+'/'+dir_path+'/*.json')
        df_filename = glob.glob(mp+'/'+dir_path+'/data_flow.py')
        with open(filename[0],'r') as data:
            try:
                _data = json.load(data)
            except Exception as error:
                raise AssertionError(error)
        M = _data['layer_obj']['ifm']['shape'][1]
        K = _data['layer_obj']['ifm']['shape'][2]
        N = _data['layer_obj']['wgt']['shape'][2]
        Msubv = _data['tile_obj']['core_tile_params']['M']
        Ksubv = _data['tile_obj']['core_tile_params']['K']
        Nsubv = _data['tile_obj']['core_tile_params']['N']
        shape_list.append(((M, K, N), (Msubv, Ksubv, Nsubv), df_filename[0]))
    return shape_list

def module_from_file(module_name, file_path):
    spec = importlib.util.spec_from_file_location(module_name, file_path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    return module

def main():
    assert len(sys.argv) == 2
    mp = sys.argv[1] #argv[1] must point to the dump folder in OGOAT
    #mp = 'C:/Users/kyleli/Downloads/AIPC/OGOAT/dump'
    dfpath = os.listdir(mp)
    shape_list = search_json_files(mp, dfpath)
    back_end = BackEnd.Txn
    cwd = os.getcwd()
    #if back_end == BackEnd.Txn:
    #    subprocess.run('rm -rf shapes', shell=True)
    for (M, K, N), (M_subv, K_subv, N_subv), df_filename in shape_list:
        compile_args = aiecompiler_args(M, K, N, M_subv, K_subv, N_subv, back_end)
        subprocess.run('make clean', shell=True)
        #generate_a16w8_gemm_qdq(M, K, N, M_subv, K_subv, N_subv, back_end)
        shutil.copyfile(df_filename, cwd+'/data_flow.py')
        #data_flow = module_from_file("main", df_filename)
        #data_flow = module_from_file("main", cwd+'/data_flow.py')
        data_flow = __import__('data_flow')
        importlib.reload(data_flow)
        data_flow.main(back_end)
        #overlay_actxwgt_act_pin_gemm_M4_N4_split.generate_a16w8_gemm_qdq(M, K, N, M_subv, K_subv, N_subv, back_end)
        subprocess.run(compile_args)
        subprocess.run(
            "sed -i 's/-ladf_api/-ladf_rt_ctrl_api -ladf_api/g' Work/ps/c_rts/systemC/Makefile",
            shell=True
        )
        subprocess.run(
            'make -C Work/ps/c_rts/systemC/ all',
            shell=True
        )
        subprocess.run(['aiesimulator', '--profile'])
        if back_end == BackEnd.Txn:
            out_folder = f'shapes/gemm_a16w8_{M}_{K}_{N}_{M_subv}_{K_subv}_{N_subv}'
            subprocess.run(f'mkdir -p {out_folder}', shell=True)
            subprocess.run(f'cp *.bin {out_folder}', shell=True)


if __name__ == '__main__':
    main()
