from onnx import TensorProto


usecase = 'OSS20B_SimplifiedLayerNormalization'

if usecase == 'PSR_MHA':
    model_name = 'OGOAT\\models\\PSR_ori_down_blocks1_mod.onnx'
    in_node_names  = {'/down_blocks.1/attentions.1/transformer_blocks.0/attn1/Unsqueeze_10_output_0':  [1, [1,1,64,1024]],
                      '/down_blocks.1/attentions.1/transformer_blocks.0/attn1/Transpose_12_output_0':  [1, [1,32,32,64]],
                      '/down_blocks.1/attentions.1/transformer_blocks.0/attn1/Unsqueeze_11_output_0': [1, [1,1,1024,64]],
                    }   
    out_node_names = {'/down_blocks.1/attentions.1/transformer_blocks.0/attn1/matmul_2.5/MatMul_output_0_DequantizeLinear_Output': [1, [1,32,32,64]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'OSS20B_SimplifiedLayerNormalization':
    model_name = "D:\\neelimap\\OSS_20B\\WAIC\\model\\model.onnx"
    in_node_names  = {'input_hidden_states_QuantizeLinear_Output':  [5, [1, 128, 2880]]}   
    out_node_names = {'/model/layers.0/input_layernorm/SimplifiedLayerNormalization_output_0_QuantizeLinear_Output': [5, [1, 128, 2880]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'PSP1_BlResize_nhwc_context':
    model_name = "D:\\kapodugu\\models_data\\PSP1_v1.1.2.onnx"
    in_node_names  = {'/depth_model/decoder/decoder_mono/upconv_2/way_trunk/act/Relu_output_0':  [1, [1,384,33,57]]}   
    out_node_names = {'/depth_model/decoder/decoder_mono/upconv_2/out_conv/Conv_output_0_DequantizeLinear_Output': [1, [1, 192, 66, 114]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'    

elif usecase == 'PSU_MHA':
    model_name = '..\\WAIC\\OGOAT\\models\\Model-PSU0-QDQ-v1_mod.onnx'
    in_node_names  = {'/model/layers.0/self_attn/Add_output_0_QuantizeLinear_Output':  [1, [1,32,512,96]],
                      '/model/layers.0/self_attn/Add_1_QuantizeLinear_Output':  [1, [1,512,32,96]],
                      'value_states_0_QuantizeLinear_Output': [1, [1,32,512,96]],
                      '/model/Where_3_output_0': [1, [1,1,512,512]],
                    }   
    out_node_names = {'/model/layers.0/self_attn/MatMul_1_output_0_QuantizeLinear_Output': []}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'PSO3_MaxPool':
    model_name = '\\\\10.228.217.196\\kapodugu\\models_data\\PSO3\\checkpoint.051-fp32-batch1.nocontrib.layernorm_fused.qdq.onnx'
    in_node_names  = {'data_QuantizeLinear_Output':  [4, [1,3,60,600]],}   
    out_node_names = {'conv2_relu_QuantizeLinear_Output': [4, [1,32,32,300]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'    

elif usecase == 'PSP1_AveragePool_1':
    model_name = '\\\\10.228.217.196\\kapodugu\\models_data\\PSP1_v1.1.2.onnx'
    in_node_names  = {'/depth_model/decoder/Tanh_1_output_0_QuantizeLinear_Output':  [4, [1,48,66,114]],}   
    out_node_names = {'/depth_model/decoder/update_block/AveragePool_output_0_QuantizeLinear_Output': [4, [1,48,33,57]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'PSP1_AveragePool_0':
    model_name = '\\\\10.228.217.196\\kapodugu\\models_data\\PSP1_v1.1.2.onnx'
    in_node_names  = {'/depth_model/decoder/Tanh_output_0_QuantizeLinear_Output':  [4, [1,48,115,199]],}   
    out_node_names = {'/depth_model/decoder/update_block_1/AveragePool_output_0_QuantizeLinear_Output': [4, [1,48,58,100]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'    

elif usecase == 'Silu_custom_op':
    model_name = 'models\\PSR_down_blocks0_mod.onnx'
    in_node_names  = {'input_2':  [1, [1,1280]]
                    }   
    out_node_names = {'/down_blocks.0/resnets.0/nonlinearity_2/Mul_output_0_QuantizeLinear_Output': []}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

##############################cut out original graph #####################################################################
elif usecase == 'testcase0':
    model_name = 'models\\sdxl_unet\\model.onnx'
    in_node_names  = {'sample':  [1, [1,4,64,64]]
                    }   
    out_node_names = {'/down_blocks.0/resnets.0/norm1/InstanceNormalization_output_0': []}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'


elif usecase == 'PSR_ori_down_blocks0':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'input_1':  [1, [1,4,64,64]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }    
    out_node_names = {'/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output': [],
                      '/down_blocks.0/attentions.0/add_1/Add_output_0_QuantizeLinear_Output': [],
                      }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx'
    ref_folder = usecase + '\\'
    
elif usecase == 'PSR_ori_down_blocks1':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output': [4, [1,320,64,64]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]}   
    out_node_names = {'/down_blocks.1/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [],
                      '/down_blocks.1/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'  : [],
                      '/down_blocks.1/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'  : [],
                      '/down_blocks.0/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': []
                      }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'
    
elif usecase == 'PSR_ori_down_blocks2':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/down_blocks.1/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [4, [1,640,16,16]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]}
    out_node_names = {'/down_blocks.2/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output' : [],
                      '/down_blocks.2/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'   : [],
                      '/down_blocks.2/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'   : [],
                    }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx'
    ref_folder = usecase + '\\'
    
elif usecase == 'PSR_ori_down_blocks3':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/down_blocks.2/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      }   
    out_node_names = {'/down_blocks.3/resnets.1/add_2/Add_output_0_QuantizeLinear_Output' : [],
                      '/down_blocks.3/resnets.0/add_2/Add_output_0_QuantizeLinear_Output' : [],
                    }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'
    
elif usecase == 'PSR_ori_mid_block':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/down_blocks.3/resnets.1/add_2/Add_output_0_QuantizeLinear_Output': [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/mid_block/resnets.1/add_2/Add_output_0_QuantizeLinear_Output' : []}
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'    
    
elif usecase == 'PSR_ori_up_blocks0':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/mid_block/resnets.1/add_2/Add_output_0_QuantizeLinear_Output'           : [4, [1,1280,8,8]],
                      '/down_blocks.2/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output'  : [4, [1,1280,8,8]],
                      '/down_blocks.3/resnets.0/add_2/Add_output_0_QuantizeLinear_Output'       : [4, [1,1280,8,8]],
                      '/down_blocks.3/resnets.1/add_2/Add_output_0_QuantizeLinear_Output'       : [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      }   
    out_node_names = {'/up_blocks.0/cats.2/Concat_output_0_QuantizeLinear_Output': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 
    
elif usecase == 'PSR_ori_up_blocks1':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/up_blocks.0/cats.2/Concat_output_0_QuantizeLinear_Output'               : [4, [1,2560,8,8]],
                      '/down_blocks.1/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output'  : [4, [1,640,16,16]],
                      '/down_blocks.2/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,1280,16,16]],
                      '/down_blocks.2/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,1280,16,16]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/up_blocks.1/cats.2/Concat_output_0_QuantizeLinear_Output': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 
    
elif usecase == 'PSR_ori_up_blocks2':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/up_blocks.1/cats.2/Concat_output_0_QuantizeLinear_Output'               : [4, [1,1920,16,16]],
                      '/down_blocks.0/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output'  : [4, [1,320,32,32]],
                      '/down_blocks.1/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,640,32,32]],
                      '/down_blocks.1/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,640,32,32]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/up_blocks.2/cats.2/Concat_output_0_QuantizeLinear_Output' : []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 
    
elif usecase == 'PSR_ori_up_blocks3':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'/up_blocks.2/cats.2/Concat_output_0_QuantizeLinear_Output'               : [4, [1,960,32,32]],
                      '/down_blocks.0/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,320,64,64]],
                      '/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'    : [4, [1,320,64,64]],
                      'input_1':  [1, [1,4,64,64]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'output_1': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 

elif usecase == 'PSR_ori_db0_ub3':
    model_name = 'models\Model_PSR_v1_0.onnx'
    in_node_names  = {'input_1':  ['input_1',  ['out' , 1, [1,4,64,64]]],
                      'input_2':  ['input_2',  ['out' , 1, [1,1280]]],
                      'input_3':  ['input_3',  ['out' , 1, [1,77,1024]]],
                      '/up_blocks.2/cats.2/Concat_output_0_QuantizeLinear': ['up_blocks.2.cats.2.Concat_output_0_QuantizeLinear', ['out', 4, [1,960,32,32]]],
                      }   
    out_node_names = {'/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear' : ['/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output', 4, [1,320,64,64]],
                      'output_1_DequantizeLinear' : ['output_1', 1, [1,4,64,64]]
            }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx'
    ref_folder = usecase + '\\'


elif usecase == 'PSR_ori_down_blocks0_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'input_1':  [1, ['n','c','h','w']],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output': [],
                      '/down_blocks.0/attentions.0/add_1/Add_output_0_QuantizeLinear_Output': [],
                      }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx'
    ref_folder = usecase + '\\'

elif usecase == 'PSR_ori_down_blocks1_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/down_blocks.0/attentions.1/add_1/Add_output_0_QuantizeLinear_Output': [4, [1,320,64,64]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]}   
    out_node_names = {'/down_blocks.1/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [],
                      '/down_blocks.1/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'  : [],
                      '/down_blocks.1/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'  : [],
                      '/down_blocks.0/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': []
                      }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'

elif usecase == 'PSR_ori_down_blocks2_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/down_blocks.1/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [4, [1,640,16,16]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]}
    out_node_names = {'/down_blocks.2/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output' : [],
                      '/down_blocks.2/attentions.1/add_1/Add_output_0_QuantizeLinear_Output'   : [],
                      '/down_blocks.2/attentions.0/add_1/Add_output_0_QuantizeLinear_Output'   : [],
                    }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx'
    ref_folder = usecase + '\\'

elif usecase == 'PSR_ori_down_blocks3_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/down_blocks.2/downsamplers.0/conv/Conv_output_0_QuantizeLinear_Output': [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      }   
    out_node_names = {'/down_blocks.3/resnets.1/add_2/Add_output_0_QuantizeLinear_Output' : [],
                      '/down_blocks.3/resnets.0/add_2/Add_output_0_QuantizeLinear_Output' : [],
                    }
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'

elif usecase == 'PSR_ori_mid_block_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/down_blocks.3/resnets.1/add_2/Add_output_0_QuantizeLinear_Output': [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/mid_block/resnets.1/add_2/Add_output_0' : []}
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\'   

elif usecase == 'PSR_ori_up_blocks0_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/mid_block/resnets.1/add_2/Add_output_0'         : [4, [1,1280,8,8]],
                      '/down_blocks.2/attentions.1/add_1/Add_output_0'  : [4, [1,1280,8,8]],
                      '/down_blocks.3/resnets.0/add_2/Add_output_0'     : [4, [1,1280,8,8]],
                      '/down_blocks.3/resnets.1/add_2/Add_output_0'     : [4, [1,1280,8,8]],
                      'input_2':  [1, [1,1280]],
                      }   
    out_node_names = {'/up_blocks.0/cats.2/Concat_output_0_QuantizeLinear_Output': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 

elif usecase == 'PSR_ori_up_blocks1_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/up_blocks.0/cats.2/Concat_output_0_QuantizeLinear_Output':[4, [1,2560,8,8]],
                      '/down_blocks.1/downsamplers.0/conv/Conv_output_0'         :[4, [1,640,16,16]],
                      '/down_blocks.2/attentions.0/add_1/Add_output_0'           :[4, [1,1280,16,16]],
                      '/down_blocks.2/attentions.1/add_1/Add_output_0'           :[4, [1,1280,16,16]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/up_blocks.1/cats.2/Concat_output_0': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 

elif usecase == 'PSR_ori_up_blocks2_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/up_blocks.1/cats.2/Concat_output_0'              : [1, [1,1920,16,16]],
                      '/down_blocks.0/downsamplers.0/conv/Conv_output_0' : [4, [1,320,64,64]],
                      '/down_blocks.1/attentions.0/add_1/Add_output_0'   : [1, [1,640,32,32]],
                      '/down_blocks.1/attentions.1/add_1/Add_output_0'   : [1, [1,640,32,32]],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'/up_blocks.2/cats.2/Concat_output_0': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 

elif usecase == 'PSR_ori_up_blocks3_concat':
    model_name = 'models\Model-PSR-v1_0.quant-changed_concat_qdq_rm_mv_q.onnx'
    in_node_names  = {'/up_blocks.2/cats.2/Concat_output_0'             : [4, [1,960,32,32]],
                      '/down_blocks.0/attentions.0/add_1/Add_output_0'  : [4, [1,320,64,64]],
                      '/down_blocks.0/attentions.1/add_1/Add_output_0'  : [4, [1,320,64,64]],
                      'input_1':  [1, ['n','c','h','w']],
                      'input_2':  [1, [1,1280]],
                      'input_3':  [1, [1,77,1024]]
                      }   
    out_node_names = {'output_1': []} 
    out_folder = usecase + '\\'
    new_model_name = usecase + '.onnx' 
    ref_folder = usecase + '\\' 

elif usecase == 'custom_run':
    model_name = ''
    in_node_names  = {}   
    out_node_names = {}
    out_folder = 'models\\'
    new_model_name = 'PSR_down_blocks0_mod.onnx'

elif usecase == 'SDXL_conv_1x4x64x64_320x4x64x64':
    #model_name = 'models\\sdxl_unet\\model.onnx'
    model_name = 'sdxl_unnet_model_mod.onnx'
    in_node_names  = {'sample':  [1, [1,4,64,64]]
                    }   
    out_node_names = {'/conv_in/Conv_output_0': []}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'SDXL_conv_4x320x64x64_320x4x3x3':
    #model_name = 'models\\sdxl_unet\\model.onnx'
    model_name = 'sdxl_unnet_model_mod.onnx'
    in_node_names  = {'/act/Mul_output_0':  [1, [1,320,64,64]]
                    }   
    out_node_names = {'out_sample': []}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'Gelu_qdq_uint16xuint16':
    model_name = 'OGOAT/models/Model_PSR_v1.1.onnx'
    in_node_names  = {'/down_blocks.1/attentions.1/transformer_blocks.0/ff/net.0/Slice_1_output_0':   [1, [1, 32, 32, 5120]]}
    out_node_names = {'/down_blocks.1/attentions.1/transformer_blocks.0/ff/net.0/gelu_1/Mul_1_output_0_DequantizeLinear_Output': [1, [1, 32, 32, 2560]]}
    out_folder = usecase + '//'
    new_model_name = usecase +'.onnx'

elif usecase == 'MatMul_qdq_biasgelu_uint16xuint8xuint16':
    model_name = './OGOAT/models/Model-PSW-QDQ-v1.onnx'
    in_node_names  = {'/deberta/encoder/layer.1/attention/output/LayerNorm/LayerNormalization_output_0': [1,[1, 64, 768]]}
    out_node_names = {'/deberta/encoder/layer.1/intermediate/intermediate_act_fn/Mul_1_output_0_DequantizeLinear_Output': [1, [1, 64, 3072]]}
    out_folder = usecase + '//'
    new_model_name = usecase +'.onnx'

elif usecase == 'Silu_qdq_uint16xuint16_1col_enable':
    model_name = './OGOAT/models/Model_PSR_v1_0.onnx'
    in_node_names  = {'input_2': [1,[1, 1280]]}
    out_node_names = {'/down_blocks.0/resnets.0/nonlinearity_2/Mul_output_0_DequantizeLinear_Output': [1, [1, 1280]]}
    out_folder = usecase + '//'
    new_model_name = usecase +'.onnx'

elif usecase == 'Add_qdq_BroadCast_uint16xuint16xuint16':
    model_name = './OGOAT/models/Model_PSR_v1.1.onnx'
    in_node_names  = {'/down_blocks.0/resnets.1/conv1/Conv_output_0': [1,[1, 320, 64, 64]],
            '/down_blocks.0/resnets.1/Unsqueeze_1_output_0': [1, [320, 1, 1]], 
                }
    out_node_names = {'/down_blocks.0/resnets.1/add_1/Add_output_0_DequantizeLinear_Output': [1, [1, 320, 64, 64]]}
    out_folder = usecase + '//'
    new_model_name = usecase +'.onnx'

elif usecase == 'Add_qdq_EleWise_uint8xuint8xuint8':
    model_name = '\\\\10.228.217.196\kapodugu\models_data\PSG0-model-1.0.294\PSG0.onnx'
    in_node_names  = {'/encoder/layers.3/fusion_layer/Mul_output_0_QuantizeLinear_Output':  [2, [1,199,63,256]],
                      '/encoder/layers.3/fusion_layer/layer_norm_vision/LayerNormalization_output_0_convert_QuantizeLinear_Output':  [2, [1,199,63,256]],
                    }   
    out_node_names = {'/encoder/layers.3/fusion_layer/Add_output_0_QuantizeLinear_Output': [2, [1,199,63,256]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

elif usecase == 'Add_qdq_BroadCast_uint8xuint8xuint8':
    model_name = '\\\\10.228.217.196\kapodugu\models_data\PSG0-model-1.0.294\PSG0.onnx'
    in_node_names  = {'/encoder/layers.0/deformable_layer/fc1/MatMul_output_0_convert_QuantizeLinear_Output':  [2, [1,199,63,2048]]}   
    out_node_names = {'/encoder/layers.0/deformable_layer/fc1/Add_output_0_QuantizeLinear_Output': [2, [1,199,63,2048]]}
    out_folder = usecase + '\\'
    new_model_name = usecase +'.onnx'

#use np_dtype_to_tensor_dtype(np.dtype(np.uint32)) to figure out type
else:
    assert 0, 'undefined test case'
