import os
import sys
import argparse
import json
from collections import OrderedDict
from tabulate import tabulate

def main(args, bypass_scheduler):
    curr_dir = (os.path.dirname(os.path.abspath(__file__)))
    target_dir = (os.path.abspath(os.path.join(os.getcwd(), args.output_dir)))
    df_dir = [ f.name for f in os.scandir(target_dir) if f.is_dir() ]

    file_list = [ f.name for f in os.scandir(target_dir) if not f.is_dir() ]
    unique_ir_file = [x for x in file_list if x.endswith('unique_nodes.json')][0]

    if not os.path.exists(os.path.join(target_dir, unique_ir_file)):
        return

    with open(os.path.join(target_dir, unique_ir_file)) as f:
        unique_ir_info = json.load(f)

    summary = OrderedDict()
    for layer in sorted([str(x) for x in df_dir]):
        layer_path = os.path.join(target_dir, str(layer))
        tiling_json = str(layer)+'.json'
        dataflow_py = 'data_flow.py'
        summary[str(layer)] = {}

        try:
          f_path = os.path.join(layer_path, tiling_json)
          with open(f_path) as f:
              tiling_info = json.load(f)
        except:
          sys.stderr.write(f"error: failed to load {f_path}\n")
          continue

        try:
            summary[str(layer)].update({  "op_type": tiling_info.get('layer_info').get('op_type'),
                                "overlay": tiling_info.get('overlay_info').get('mode'),
                                "shape"  : (unique_ir_info[str(layer)].get('in_act_shape'),
                                            unique_ir_info[str(layer)].get('in_wgt_shape'),
                                            unique_ir_info[str(layer)].get('out_act_shape')),
                                "subv"   : tiling_info.get('core_tile_params').get('subvols'),
                                "padding": tiling_info.get('dma_layer_padding'),
                                'overlay': tiling_info.get('overlay_info'),
                                'schedule': tiling_info.get('scheduling'),
                                "qdq_symmetry": unique_ir_info[str(layer)].get('qdq_symmetry'),
                                "coeff_shape": unique_ir_info[str(layer)].get('coeff_shape'),
                                "frequency": unique_ir_info[str(layer)].get('Frequency'),
                            })

            if not os.path.exists(os.path.join(layer_path, tiling_json)):
                summary[str(layer)]['message'] = 'Tiling Json not generated'
                continue

            if not os.path.exists(os.path.join(layer_path, dataflow_py)):
                summary[str(layer)]['message'] = 'data_flow.py not generated'
        except:
            pass

    with open(os.path.join(target_dir, 'summary.txt'),'w') as f:
        for key, val in summary.items():
            print(f'{key}: {val}', file=f)

    table_data = [[key, value] for key, value in summary.items()]
    with open(os.path.join(target_dir, 'summary_table.txt'),'w') as f:
        print(tabulate(table_data, headers=["Key", "Value"], tablefmt="grid"), file=f)

if __name__ == "__main__":
	parser = argparse.ArgumentParser(description="WAIC Compile Summary Reporting",
                                   usage='use "%(prog)s --help" for more info',
                                   formatter_class=argparse.RawTextHelpFormatter)

	#Required args
	parser.add_argument("-path", "--output_dir", required=True, help="Path to onnx model (or JSON) and output destination")
	args = parser.parse_args()
	main(args, 0)
