import pandas as pd
import argparse

def compare_excel_columns(file1_path, file2_path):
    file1 = pd.read_excel(file1_path, engine='openpyxl')
    file2 = pd.read_excel(file2_path, engine='openpyxl')
    
    test_file  = file1.iloc[:, [6, 7]] #extract status and latency
    gold_file    = file2.iloc[:, [6, 7]] #extract status and latency

    # expect new latency to be in +/-5% range from golden
    test_latency_match = ((test_file.iloc[:, 0] - gold_file.iloc[:, 0]).abs() <= gold_file.iloc[:, 0] * 0.05).all()
    # expect test to be always passing
    test_status_match = test_file.iloc[:, 1].equals(gold_file.iloc[:, 1])

    return test_status_match, test_latency_match

def main(args):
    print(args)
    is_DI_clean, is_perf_clean = compare_excel_columns(args.result_path, args.gold_path)
    print(f"DI Clean: {is_DI_clean}")
    print(f"Perf values match within +/- 5% of golden: {is_perf_clean}")
    assert is_DI_clean and is_perf_clean, f"Perf check failed. is_DI_clean:{is_DI_clean} is_perf_clean:{is_perf_clean}"

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description="Windows AI Compiler (WAIC) - build and run MLOPs on AIESim",
        usage='use "%(prog)s --help" for more info',
        formatter_class=argparse.RawTextHelpFormatter,
    )

    # Required args
    parser.add_argument(
        "-res",
        "--result_path",
        required=True,
        help="Path to xlsx file from the current run",
    )
    # Required args
    parser.add_argument(
        "-gold",
        "--gold_path",
        required=True,
        help="Path to golden file",
    )
    args = parser.parse_args()
    main(args)




