import json
import sys
import glob
from pathlib import Path

def main():
    #base_path = Path("./WAIC_Outputs_mha/mha_unit_test/mha_mini")
    base_path = Path("./WAIC_Outputs_mha/")
    json_files = list(base_path.glob("output_*.json"))

    if not json_files:
        print("No output_*.json files found! Failing CI.")
        sys.exit(1)

    print(f"Found {len(json_files)} JSON file:")
    for f in json_files:
        print(f" - {f}")

    failures = []

    for file in json_files:
        try:
            with open(file, 'r') as f:
                data = json.load(f)
                if not isinstance(data, list):
                    print(f"File {file} does not contain a JSON array.")
                    sys.exit(1)
                for i, entry in enumerate(data):
                    if entry.get("Pass or Fail") == "Fail":
                        failures.append((file, i + 1, entry.get("Shape")))
        except json.JSONDecodeError as e:
            print(f"JSON decode error in file {file}: {e}")
            sys.exit(1)

    if failures:
        print("Failures detected:")
        for file, idx, shape in failures:
            print(f" - File: {file}, Entry #{idx}, Shape: {shape}")
        sys.exit(1)

    print("All shapes passed.")

if __name__ == "__main__":
    main()
