# fmt: on
from abc import ABC, abstractmethod
from OGOAT.src.L1_fusion.py_match.checkers import opType
from OGOAT.src.L1_fusion.py_match.helpers.qdq_helper import QDQHelper
from OGOAT.src.L1_fusion.py_match.nodes_tensors import Matcher


class RemoveHelper(Matcher, QDQHelper, ABC):
    """
    Base class of several remove and cleanup patterns.
    """

    def __init__(self):
        self.input = None
        self.output = None

    @abstractmethod
    def set_input_and_output(self) -> None:
        """
        Sets input and output elements
        e.g.:
        self.input = n("input")
        self.output = n("output")
        """

    @abstractmethod
    def match_op_specifics(self) -> None:
        """
        Matches op specific requirements
        """

    def match(self) -> None:
        self.set_input_and_output()
        self.match_op_specifics()
        if (
            self.input.check(opType.DequantizeLinear)
            and self.output.check(opType.QuantizeLinear)
            and self.check_qdq_equal_scale_zeropoint(self.input, self.output)
        ):
            self.input = self.input("x")
            self.output = self.output("y")

    def modify(self) -> None:
        n = self.n
        self.connect(self.output, self.input)
        self.remove_node(n)
