# fmt: on
from typing import TypeAlias,NamedTuple
from onnx import NodeProto, TensorProto, ValueInfoProto
from numpy import ndarray

IndexArray: TypeAlias = list[int]
"""IndexArray: an array of indices in some list"""

Perm: TypeAlias = list[int] | IndexArray
"""Perm: IndexArray with non-repeating elements from 0 to len(Perm) - 1"""

TensorShape: TypeAlias = list[int] | tuple[int]
"""TensorShape: list of **positive** integers  """

ShapeMask: TypeAlias = list[IndexArray]
"""ShapeMask: **list of lists**, mask's elements are IndexArrays, referred as "groups"""

OnnxElement: TypeAlias = NodeProto | TensorProto | ValueInfoProto
"""OnnxElement: a Protobuf element of a onnx-graph -- NodeProto, TensorProto, ValueInfoProto"""

NodeDict: TypeAlias = dict[str: str|dict]
"""NodeDict -- a dict with node's data to use in Matcher.add_node(**node_dict)"""

NumpyDType: TypeAlias = str
OnnxDType: TypeAlias = int

class NamedArray(NamedTuple):
    name: str
    array: ndarray | list
    dtype: NumpyDType
