import sys
import argparse
import os

if os.name == 'nt':
    inc_path = os.path.abspath("./runtime_build/runtime/Release")
else:
    inc_path = os.path.abspath("./runtime_build/runtime")
sys.path.append(inc_path)

import waic_runtime
import os

parser = argparse.ArgumentParser(description="Json files")
parser.add_argument("--tiling_json", required=True)
parser.add_argument("--ir_json", required=True)
parser.add_argument("--wgt_folder", default="WAIC_Outputs/DataGen/Consts", required=False)
parser.add_argument("--txn_bin_folder", default="WAIC_Outputs/", required=False)
parser.add_argument("--xrt", default=False, type=bool, required=False)
parser.add_argument("--conv", required=False)
parser.add_argument("--txn_bin", required=False)
args = parser.parse_args()
tiling_json = args.tiling_json
ir_json = args.ir_json
wgt_folder = args.wgt_folder
txn_bin_folder = args.txn_bin_folder
xrt = args.xrt
is_psv_conv = args.conv

if is_psv_conv:
    try:
        txn_bin = args.txn_bin
    except IndexError:
        print("If --conv option is specified need to pass txn.bin path via --txn_bin option")
        sys.exit(1)
    waic_runtime.txn_update(wgt_folder, ir_json, tiling_json, txn_bin, "./")
else:
    waic_runtime.txn_update_all(wgt_folder, txn_bin_folder, tiling_json, xrt)
