import sys
import argparse
import os
import json

if os.name == 'nt':
    inc_path = os.path.abspath("./runtime_build/runtime/Release")
else:
    inc_path = os.path.abspath("./runtime_build/runtime")
sys.path.append(inc_path)

import waic_runtime

parser = argparse.ArgumentParser(description="Json files")
parser.add_argument("--tiling_json", required=True)
parser.add_argument("--ir_json", required=True)
parser.add_argument("--wgt_folder", default="WAIC_Outputs/DataGen/Consts",
                    required=False)
parser.add_argument("--bin_folder", default="WAIC_Outputs/", required=False)
parser.add_argument("--op_list", required=False)
parser.add_argument("--id_list", required=False)
parser.add_argument("--debug", default=False, type=bool, required=False)
args = parser.parse_args()
tiling_json = args.tiling_json
ir_json = args.ir_json
wgt_folder = args.wgt_folder
bin_folder = args.bin_folder
debug = args.debug

with open(tiling_json) as f:
    tiling_dict = json.load(f)

id_list = []
if args.op_list == None and args.id_list == None:
    id_list = list(tiling_dict.keys())
elif args.op_list == None and args.id_list != None:
    id_list = args.id_list.split(',')
elif args.op_list != None and args.id_list == None:
    op_list = args.op_list.split(',')
    for key, value in tiling_dict.items():
        if value['layer_info']['op_type'] in op_list:
            id_list.append(key)
else:
    op_list = args.op_list.split(',')
    for key, value in tiling_dict.items():
        if value['layer_info']['op_type'] in op_list:
            id_list.append(key)
    id_list.extend(args.id_list.split(','))

print("Formatting weights for all nodes")
print(os.getcwd())
waic_runtime.wgt_formatting(wgt_folder, bin_folder, 
                              tiling_json, id_list, debug)
