import OGOAT.src.Scheduling_Engine.infra.scheduler_utils as utils
import pdb
from types import MappingProxyType    #To make it read only

class ReadOnlyDict:
	def __init__(self, init_data):
		#Used name mangling to ensure no one can access member variable directly
		self.__read_only_dict =  self._make_read_only(init_data)
	
	def _make_read_only(self, data):
		#To ensure even for nested dict value are of type "MappingProxyType"
		if isinstance(data, dict):
				return MappingProxyType({k: self._make_read_only(v) for k, v in data.items()})
		elif isinstance(data, list):
				return tuple(self._make_read_only(item) for item in data)
		else:
				return data
	
	def get_dict(self):
		return self.__read_only_dict

	def get_value(self, input_key, input_dict=None):
		#NOTE- It supports nested dict
		if input_dict is None:
			input_dict = self.__read_only_dict

		if input_key in input_dict:
			return input_dict[input_key]

		for key, value in input_dict.items():
			if isinstance(value, MappingProxyType):
				result = self.get_value(input_key, value)
				if result is not None:
					return result

