import os
import logging
import json
import pdb
from enum import Enum

class DEBUG_VERBOSE(Enum):
	debug = logging.DEBUG
	info  = logging.INFO
	error = logging.ERROR
	
	@classmethod
	def str2enum(enum_class, string_val):
		if string_val in enum_class.__members__:
			return enum_class[string_val]
		else:
			sanity_check(False,"String not found. Str: "+str(string_val))


def check_file_type(filename, expected_file_type):
	if filename.lower().endswith(expected_file_type) is False:
			sanity_check(False,"Incorrect file type. expected_file_type: "+expected_file_type+", File Path: "+filename)

	if not os.path.exists(filename):
			sanity_check(False,"File not found. Filename: "+filename)

def is_json_file(filename):
	return filename.lower().endswith('.json')

def sanity_check(condition, message, level="Error"):
	if not condition:
		if level == "Error":
			raise AssertionError("\033[91m"+message+"\033[0m")
		elif level == "Warning":
			print("\033[33mWarning: "+message+"\033[0m")
		elif level == "Message":
			print("Message: "+message)

def load_file(filename):
	_data = ""
	with open(filename,'r') as data:
		try:
			if filename.lower().endswith(".json"):
				_data = json.load(data)
			else:
				sanity_check(False,"Unsupported file type. File Name: "+filename)
			logging.debug("Loading File: %s",filename)
			logging.debug("Data: %s",_data)
		except Exception as error:
				logging.error("%s",error)
	return _data

def convert_values_to_int(d):
	for key in d:
		try:
			d[key] = int(d[key])
		except ValueError:
			pass  # If the value cannot be converted to int, leave it as is
	return d

def find_key_in_dict(input_dict, input_key):
	#NOTE- Supports nested dict
	#TODO - Handle duplicate key in nested dict
	if input_key in input_dict:
			return input_dict[input_key]

	for key, value in input_dict.items():
			if isinstance(value, dict):
					result = find_key_in_dict(input_key, value)
					if result is not None:
							return result

	logging.debug("Key: %s, not found", input_key)
	return None
