from OGOAT.src.Tiler.dataflow_tiler import DataflowTiler
from dataflow.concat.concat_run_tiler import ConcatDims


class ConcatTiler(DataflowTiler):
    def __init__(self, layer, device, overlay):
        super().__init__(layer, device, overlay)
        # 0: ch-wise; 1: col/width-wise
        self.concat_mode = 1
        self.ifm_bits = 16
        self.ofm_bits = 1

    def calculate_memtile_tilings(self):
        pass

    def check_valid_memtile_tilings(self):
        pass

    def calculate_array_tilings(self):
        pass

    def check_core_constraints(self):
        pass

    def get_op_dims(self):
        return ConcatDims(
            self.aie_rows,
            self.aie_cols,
            self.num_inputs,
            self.concat_mode,
            self.input_rows,
            self.input_cols,
            self.input_chs,
            self.ifm_bits,
            self.ofm_bits,
        )
