# import abc
from OGOAT.src.Tiler.layer import Layer
from OGOAT.src.Tiler.op_dims import OpDims
from OGOAT.src.Tiler.overlay import Overlay
import ast
from dmacompiler import config


class DataflowTiler:

    def __init__(self, layer: Layer, device, overlay: Overlay):
        self.layer = layer
        self.overlay = overlay
        self.device = device
        self.aie_rows = overlay.rows
        self.aie_cols = overlay.cols
        inputs = ast.literal_eval(layer.__getattribute__("inputs"))
        act_inputs = [x for x in inputs if x["type"] == "act"]
        self.num_inputs = len(act_inputs)
        self.input_rows = [x["shape"][0] for x in act_inputs]
        self.input_cols = [x["shape"][1] for x in act_inputs]
        self.input_chs = [1] * self.num_inputs
        self.param_subv_size = config.MAX_CORE_LAYER_PARAM_SIZE

    def calculate_memtile_tilings(self):
        pass

    def check_valid_memtile_tilings(self):
        pass

    def calculate_array_tilings(self):
        pass

    def check_core_constraints(self):
        pass

    # @abc.abstractmethod
    def get_op_dims(self) -> OpDims:
        pass
