import yaml
import os

from OGOAT.src.Tiler.device import Device
from OGOAT.src.Tiler.layer import Layer
from OGOAT.src.Tiler.tiling_result import TilingResult
from OGOAT.src.Tiler.tiler import Tiler
from overlay import Overlay
# import abc

parent_dir = os.path.dirname(
    os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
)


class DataflowTilingOpt:
    def __init__(self, layer: Layer, device: Device, overlay_name: str):
        with open(os.path.join(parent_dir, "Collaterals", "overlays.yaml")) as f:
            all_overlays = yaml.safe_load(f)
        self.modes = list(all_overlays[overlay_name][layer.orig_op_type].keys())
        overlay = Overlay(overlay_name, layer.orig_op_type,self.modes[0])
        self.overlay_name = overlay_name
        # FIXME for now take first tiler as optimal tiler
        self.tiler = Tiler(layer, device, overlay)
        self.mode = self.modes[0]

    # @abc.abstractmethod
    def find_optimal_tiling(self) -> TilingResult:
        layerdict = vars(self.tiler.layer)
        tiling_params = {
            'layer_info': layerdict,
            'overlay_info': {'overlay':self.overlay_name, 'mode':self.mode,'shape':{'row':self.tiler.overlay.rows,'col':self.tiler.overlay.cols}}
        }
        return tiling_params
