import yaml
import os

class Device:

    def __init__(self, device):
        cwd = (os.path.dirname(os.path.abspath(__file__)))
        with open(cwd+'/../../Collaterals/device.yaml') as f:
            device_dict = yaml.safe_load(f)
        
        for key, val in device_dict[device].items():
            setattr(self, key, val)

        # Calculate memtile capacity in bytes from device (given in KB)
        self.memtile_capacity_bytes = self.memtile_capacity * 1024
        
        # Calculate core data memory size in bytes (core_data_memory is in KB)
        self.core_data_mem_size = self.core_data_memory * 1024

        self.core_freq_hz = self.core_clock_freq * (10 ** 9)  # convert from GHz to Hz
