import yaml
import os
import sys
import glob
from typing import Optional

parent_dir = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

class KernInfoFromYaml:
    def __init__(self):
        yaml_files = glob.glob(os.path.join(parent_dir,'Collaterals/*_kernel_metadata.yaml'))

        self.kernel_dict = {}
        for file in yaml_files:
            with open(file) as f:
                kd = yaml.safe_load(f)
                self.kernel_dict.update(kd)

    def get_all_kern_info(self):
        return self.kernel_dict

class Kernel:

    def __init__(self, layer, _kernel_list_path:str='',
                 all_kern_info:Optional[KernInfoFromYaml]=None):

        self.kernel_list_path = _kernel_list_path

        if all_kern_info is None:
            all_kern_info = KernInfoFromYaml()
        kernel_dict = all_kern_info.get_all_kern_info()

        op_type = layer.op_type
        if op_type in kernel_dict:
            for key, val in kernel_dict[op_type].items():
                if type(val)==dict:
                    for k, v in val.items():
                        setattr(self, k, v)
                setattr(self, key, val)
        else:
            print(f"Undefined operator: {op_type}")
            raise Exception(f"Undefined operator: {op_type}")

        self.is_xint8 = getattr(self,'is_xint8',0)
        self.is_a8w8 = getattr(self,'is_a8w8',0)
        self.layer_param_size = 0
        self.enable_add = False
        # For Conv operations, derive layer_param_size from YAML config and setup Conv-specific operations
        if 'Conv' in layer.orig_op_type:
            self.layer_param_size = self.conv_kernel_param_size + self.qdq_param_size
            
            # Check if an add is fused with this conv
            self.enable_add = 'add' in layer.op_type.lower()

            # TODO: Check if yaml can be updated appropriately
            if layer.strides[1] == 2:
                self.subvol_constraints['X_gran'] = 8

