## Description

Provide a clear and concise description of your changes

## Type of Change

Mark the relevant option with an 'x'

- [ ] `feat`: New feature
- [ ] `fix`: Bug fix
- [ ] `docs`: Documentation changes
- [ ] `style`: Code style changes (formatting, etc.)
- [ ] `refactor`: Code refactoring
- [ ] `test`: Adding or updating tests
- [ ] `chore`: Maintenance tasks

## Checklist

- [ ] Code passes linters (`sh lint.sh py`)
- [ ] Regression tests pass (`bash dma_check.sh`)
- [ ] Unit tests pass (`bash pytests.sh`)
- [ ] Coverage tests pass (`bash coverage.sh`)
- [ ] Documentation (README) updated
- [ ] Branch up to date with `main`
- [ ] No merge conflicts
- [ ] New features have corresponding pytests added
