# Windows E2E Test Scripts

PowerShell scripts for running model E2E tests on Windows machines with NPU hardware.

## Prerequisites

1. **Model Data**: ORT/Model data-generation is time-consuming and must be done beforehand.
   - Pre-generated data available at: `\\10.228.218.179\c$\Users\Administrator\xiaohanc\models`

2. **SSH Key**: `gitenterprise_windows` and `gitenterprise_windows.pub` for GitHub Enterprise access

3. **Wheel Files** (one-time setup): `*.whl` files for conda environment
   - Latest wheels: `\\10.228.200.62\Users\Administrator\wheels\wheels_waic_latest\2516`
   - Confluence: <https://amd.atlassian.net/wiki/spaces/AIG/pages/1312449025/AIE4+Model+Test+Flow>

   **Important:** In the latest wheels (2516+), `onnxsim`, `onnxruntime`, and `onnxruntime-extensions`
   are removed from the waic wheel. For E2E scripts that require `onnxruntime-extensions`,
   install in this order:

   ```powershell
   pip install onnxruntime
   pip install onnxruntime-extensions
   pip install waic-*.whl
   pip install onnxruntime_vitisai-*.whl
   pip install voe-*.whl
   ```

## Scripts Overview

| Script                        | Purpose                                                                                       |
|-------------------------------|-----------------------------------------------------------------------------------------------|
| `bootstrap_machine.ps1`       | One-time Windows machine setup (choco, vim, OpenSSH, SSH keys) - run ON Windows               |
| `bootstrap_windows.sh`        | Bootstrap Windows machine FROM Linux (sync scripts, run init, sync repos)                     |
| `init.ps1`                    | One-time conda environment setup (creates `ci_etoe` env, installs wheels)                     |
| `setup_env.ps1`               | Configure conda and git SSH settings (dot-source this)                                        |
| `settings_qhw4_pkg.ps1`       | Set WAIC/aie4_models environment variables                                                    |
| `sync_models_repo.ps1`        | Sync [IPSP/models](https://gitenterprise.xilinx.com/IPSP/models)                              |
| `sync_aie4_repo.ps1`          | Sync [IPSP/aie4_models](https://gitenterprise.xilinx.com/IPSP/aie4_models) to specific commit |
| `compile_run_qhw4_debug.ps1`  | Compile and run model tests (use `-SkipExecute` for compile only)                             |
| `run_compiled_qhw4_debug.ps1` | Run pre-compiled model tests (skip compilation)                                               |
| `copy_to_remote.ps1`          | Direct Windows-to-Windows file copy via rclone SFTP (used by `--via-ssh`)                     |

### Python Scripts (in parent directory)

| Script              | Purpose                                                                 |
|---------------------|-------------------------------------------------------------------------|
| `e2e_test.py`       | Main test runner - SSH to Windows and run tests                         |
| `copy_artifacts.py` | Copy files between machines (`--via-ssh` for direct transfer)           |

## Quick Start

### Bootstrap a New Windows Machine

**Step 1: On the Windows machine (as Administrator):**

```powershell
# Get your SSH public key from Linux: cat ~/.ssh/id_rsa.pub
.\bootstrap_machine.ps1 -PublicKey "ssh-rsa AAAA..."
# Or run without args to be prompted
.\bootstrap_machine.ps1
```

This installs Chocolatey, vim, configures OpenSSH, and sets up SSH key auth.

**Step 2: From Linux:**

```bash
# Verify SSH works without password
ssh administrator@<windows-ip> "echo ok"

# Bootstrap the machine (copies scripts, wheels, runs init and sync)
./HW_requirements/scripts/bootstrap_windows.sh <windows-ip>
```

### One-time Setup (Manual)

```powershell
# From C:\Users\Administrator\Desktop\shajaisw
.\init.ps1
```

### Run Model Tests

```powershell
# Sync repositories
.\sync_models_repo.ps1
.\sync_aie4_repo.ps1                          # Sync to origin/main
.\sync_aie4_repo.ps1 -Commit "abc123"         # Sync to specific commit

# Compile and run (first time or after code changes)
.\compile_run_qhw4_debug.ps1 psd1
.\compile_run_qhw4_debug.ps1 psd2

# Compile only (for split compile/run workflow)
.\compile_run_qhw4_debug.ps1 psd1 -SkipExecute

# Re-run with pre-compiled artifacts (faster)
.\run_compiled_qhw4_debug.ps1 psd1
```

## Supported Models

- `psd1`
- `psd2`
- `psd3`
- `psd4`
- `psh`
- `psi`
- `psu0`
- `psu1`
- `vit-base`

## Directory Structure

```text
C:\Users\Administrator\Desktop\shajaisw\
├── gitenterprise_windows          # SSH private key for gitenterprise
├── gitenterprise_windows.pub      # SSH public key
├── *.whl                          # Wheel files for init
├── *.ps1                          # PowerShell scripts
├── models/                        # Synced from IPSP/models
│   ├── psd1/
│   └── psd2/
├── psd1/                          # Model working directory
│   ├── model.onnx
│   ├── DataGen/
│   │   ├── Activations/ort/
│   │   └── Consts/
│   ├── waic_work_compile/         # Compiled artifacts
│   └── report.csv                 # Test results
└── psd2/
    └── ...
```

## CI Integration

These scripts are called by `HW_requirements/e2e_test.py` via SSH.
See [../README.md](../README.md) for usage examples and developer workflows.

## Troubleshooting

### SSH Key Issues

```powershell
# Verify SSH key exists
Test-Path C:\Users\Administrator\Desktop\shajaisw\gitenterprise_windows

# Test SSH connection
ssh -i .\gitenterprise_windows git@gitenterprise.xilinx.com
```

### Conda Environment Issues

```powershell
# List environments
conda env list

# Remove and recreate
conda env remove -n ci_etoe
.\init.ps1
```

### Missing DataGen

Copy from network share:

```powershell
$model = "psd1"
Copy-Item -Recurse "\\10.228.218.179\c$\Users\Administrator\xiaohanc\models\$model\DataGen" ".\$model\DataGen"
```
