# run_compiled_qhw4_debug.ps1
# Run pre-compiled QHW4 debug tests for a model (skip compilation)
#
# Usage:
#   .\run_compiled_qhw4_debug.ps1              # Default: psd1
#   .\run_compiled_qhw4_debug.ps1 -Model psd2  # Specific model
#   .\run_compiled_qhw4_debug.ps1 -Model psd1 -WorkDir "D:\test"  # Custom work dir

param(
    [Parameter(Position=0)]
    [string]$Model = "psd1",

    [Parameter()]
    [string]$WorkDir = "C:\Users\Administrator\Desktop\shajaisw"
)

$ErrorActionPreference = "Stop"

$basePath = "$WorkDir\$Model"
$compileDir = "$basePath\waic_work_compile"
$repoPath = "C:\ProgramData\miniforge3\envs\ci_etoe\Lib\site-packages\aie4_models"

Write-Host "=== Run Pre-compiled: $Model ===" -ForegroundColor Cyan

# Validate compiled artifacts exist
if (-not (Test-Path $compileDir)) {
    Write-Error "Work directory not found: $compileDir. Run compile_run_qhw4_debug.ps1 first."
    exit 1
}

# Setup
Set-Location $basePath
New-Item -ItemType Directory -Path $compileDir -Force | Out-Null

# Clean old report
Remove-Item -Path "$basePath\report.csv" -Force -ErrorAction SilentlyContinue

conda activate ci_etoe
. ..\settings_qhw4_pkg.ps1

Set-Location $repoPath

python .\debug_scripts\qhw4_op_level_debug.py `
    -mp "$basePath\model.onnx" `
    -fe "$basePath" `
    -output "$compileDir" `
    -ort "$basePath\DataGen\Activations\ort\" `
    --runner .\debug_scripts\waic_runner.exe `
    -wgt --subgraph --skip_compiling

if ($LASTEXITCODE -ne 0) {
    Write-Error "qhw4_op_level_debug.py failed with exit code: $LASTEXITCODE"
    exit $LASTEXITCODE
}

Get-Content "$repoPath\debug_scripts\report.csv"
Copy-Item "$repoPath\debug_scripts\report.csv" "$basePath"

Write-Host "=== Complete ===" -ForegroundColor Green