# settings_qhw4_pkg.ps1
# WAIC PowerShell Environment Setup Script
#
# Sets up Python paths for WAIC/aie4_models modules
# Usage: . .\settings_qhw4_pkg.ps1  (dot-source to inherit env vars)

$ErrorActionPreference = "Stop"

$QHW4_DIR = "$env:CONDA_PREFIX\Lib\site-packages\aie4_models"
$env:AIE4_ROOT_DIR = $QHW4_DIR
$DMACOMPILER_DIR = "$QHW4_DIR\dmacompiler"
$env:PYTHONPATH = "$DMACOMPILER_DIR;$QHW4_DIR"
$env:XAIENGINE_PATH = Join-Path $QHW4_DIR "dmacompiler\aie-rt\build_windows\include"
$env:XAIENGINE_HEADER_PATH = Join-Path $QHW4_DIR "dmacompiler\aie-rt\build_windows\include\xaiengine"
$env:LIBRARY_PATH_XAIENGINE = Join-Path $QHW4_DIR "dmacompiler\aie-rt\build_windows\Debug"

# Verify required paths exist
if (-not (Test-Path $QHW4_DIR)) {
    Write-Error "aie4_models not found: $QHW4_DIR"
    exit 1
}
if (-not (Test-Path $env:LIBRARY_PATH_XAIENGINE)) {
    Write-Error "XAIENGINE library path does not exist: $env:LIBRARY_PATH_XAIENGINE"
    exit 1
}

$env:PATH = "$env:LIBRARY_PATH_XAIENGINE;$env:PATH"

Write-Host "Environment configured: $QHW4_DIR" -ForegroundColor Green