# setup_env.ps1
# Setup conda environment and git configuration for CI
#
# Usage: . .\setup_env.ps1  (dot-source to inherit env vars)
#        . .\setup_env.ps1 -WorkDir "D:\test"  # Custom work dir

param(
    [Parameter()]
    [string]$WorkDir = "C:\Users\Administrator\Desktop\shajaisw"
)

$ErrorActionPreference = "Stop"

# Activate conda environment
conda activate ci_etoe
if ($LASTEXITCODE -ne 0) {
    Write-Error "Failed to activate conda environment 'ci_etoe'"
    exit 1
}

# Configure git for SSH access to gitenterprise
$env:GIT_TERMINAL_PROMPT = 0
$SshKeyPath = "$WorkDir\gitenterprise_windows"
if (-not (Test-Path $SshKeyPath)) {
    Write-Warning "SSH key not found: $SshKeyPath"
}
# Use a temp file for known_hosts to avoid issues with NUL device name in certain directories
$TempKnownHosts = "$env:TEMP\ssh_known_hosts_temp"
$env:GIT_SSH_COMMAND = "ssh -i `"$SshKeyPath`" -o StrictHostKeyChecking=no -o UserKnownHostsFile=`"$TempKnownHosts`""

# Use environment variables for URL rewrite (session-scoped, not global)
# GIT_CONFIG_COUNT + GIT_CONFIG_KEY_*/GIT_CONFIG_VALUE_* override config without persistence
$env:GIT_CONFIG_COUNT = "1"
$env:GIT_CONFIG_KEY_0 = "url.git@gitenterprise.xilinx.com:.insteadOf"
$env:GIT_CONFIG_VALUE_0 = "https://gitenterprise.xilinx.com/"