# sync_models_repo.ps1
# Sync the models repository from gitenterprise
#
# Usage: .\sync_models_repo.ps1
#        .\sync_models_repo.ps1 -WorkDir "D:\test"  # Custom work dir

param(
    [Parameter()]
    [string]$WorkDir = "C:\Users\Administrator\Desktop\shajaisw"
)

$ErrorActionPreference = "Stop"

. .\setup_env.ps1 -WorkDir $WorkDir

$modelsPath = "$WorkDir\models"
$repoUrl = "git@gitenterprise.xilinx.com:IPSP/models.git"

Write-Host "=== Syncing models repository ===" -ForegroundColor Cyan
Write-Host "Path: $modelsPath"

try {
    if (Test-Path $modelsPath) {
        Push-Location $modelsPath
        Write-Host "Fetching updates..." -ForegroundColor Yellow
        git fetch origin
        if ($LASTEXITCODE -ne 0) { throw "git fetch failed" }
        git reset --hard origin/main
        if ($LASTEXITCODE -ne 0) { throw "git reset failed" }
        git checkout -B main origin/main
        if ($LASTEXITCODE -ne 0) { throw "git checkout failed" }
        Pop-Location
    } else {
        Write-Host "Cloning repository..." -ForegroundColor Yellow
        git clone $repoUrl $modelsPath
        if ($LASTEXITCODE -ne 0) { throw "git clone failed" }
    }

    Push-Location $modelsPath
    Write-Host "Updating submodules..." -ForegroundColor Yellow
    git submodule update --init --recursive
    if ($LASTEXITCODE -ne 0) { throw "git submodule update failed" }

    $currentCommit = git rev-parse --short HEAD
    Write-Host "=== Sync complete: $currentCommit ===" -ForegroundColor Green
}
catch {
    Write-Error "Failed: $_"
    exit 1
}
finally {
    Pop-Location -ErrorAction SilentlyContinue
}